/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.util;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.apache.commons.math3.util.ArithmeticUtils;

public final class FourierUtils {
    private FourierUtils() {
    }

    public static Complex[] fft(double[] data) {
        if (!ArithmeticUtils.isPowerOfTwo((long)data.length)) {
            data = FourierUtils.padWithZeros(data, FourierUtils.nextPowerOfTwo(data.length) - data.length);
        }
        FastFourierTransformer transformer = new FastFourierTransformer(DftNormalization.STANDARD);
        return transformer.transform(data, TransformType.FORWARD);
    }

    public static double[] padWithZeros(double[] data, int padLength) {
        return ArrayUtils.addAll((double[])data, (double[])new double[padLength]);
    }

    public static int nextPowerOfTwo(int n) {
        int count = 0;
        if (n > 0 && (n & n - 1) == 0) {
            return n;
        }
        while (n != 0) {
            n >>= 1;
            ++count;
        }
        return 1 << count;
    }

    public static double squareMagnitude(Complex n) {
        return n.getReal() * n.getReal() + n.getImaginary() * n.getImaginary();
    }
}

