/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.util;

import com.ibm.bi.predict.algorithms.forecasting.util.FourierUtils;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.special.Gamma;

public final class HannanNicholls {
    private HannanNicholls() {
    }

    public static double estimatePEV(double[] data, int season, int m) {
        double[] ut = HannanNicholls.nStepDiff(data, season);
        double[] I = HannanNicholls.sampleSpectrum(ut);
        int n = ut.length;
        int M = (n - 1) / (2 * m);
        double sum = 0.0;
        for (int j = 0; j <= M - 1; ++j) {
            double inner = 0.0;
            for (int k = 1; k <= m; ++k) {
                inner += Math.PI * 2 * I[j * m + k - 1];
            }
            sum += Math.log(inner);
        }
        return (double)m * Math.exp(sum / (double)M - Gamma.digamma((double)m));
    }

    public static double[] sampleSpectrum(double[] data) {
        double[] u = HannanNicholls.meanDiff(data);
        Complex[] fourier = FourierUtils.fft(u);
        int n = fourier.length;
        return IntStream.range(1, n / 2 + 1).mapToDouble(i -> FourierUtils.squareMagnitude(fourier[i]) / (Math.PI * 2 * (double)n)).toArray();
    }

    public static double[] meanDiff(double[] data) {
        double mean = Arrays.stream(data).average().orElseThrow(IllegalStateException::new);
        return IntStream.range(0, data.length).mapToDouble(i -> data[i] - mean).toArray();
    }

    public static double[] nStepDiff(double[] data, int n) {
        return IntStream.range(n, data.length).mapToDouble(i -> data[i] - data[i - n]).toArray();
    }
}

