/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.util;

import com.ibm.bi.predict.algorithms.forecasting.es.ESFit;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.util.CombinatoricsUtils;

public class KendallTauTrendAnalysis {
    private double[] x;
    private Map<Double, Integer> xFreq;
    private double tau;
    private double S;
    private double varS;
    private double g;
    private double z;
    private double p;

    public KendallTauTrendAnalysis(ESFit fit) {
        this.x = fit.diagnostics().decomposition()[1];
        this.xFreq = KendallTauTrendAnalysis.freqCount(this.x);
        this.S = KendallTauTrendAnalysis.S(this.x);
        this.tau = KendallTauTrendAnalysis.tau(this.S, this.x);
        this.g = KendallTauTrendAnalysis.g(this.xFreq);
        this.varS = KendallTauTrendAnalysis.varS(this.g, this.x);
        this.z = KendallTauTrendAnalysis.z(this.S, this.varS);
        this.p = KendallTauTrendAnalysis.p(this.z);
    }

    private static Map<Double, Integer> freqCount(double[] x) {
        HashMap<Double, Integer> xFreq = new HashMap<Double, Integer>();
        for (int i = 0; i < x.length; ++i) {
            if (xFreq.containsKey(x[i])) {
                xFreq.put(x[i], (Integer)xFreq.get(x[i]) + 1);
                continue;
            }
            xFreq.put(x[i], 1);
        }
        return xFreq;
    }

    private static double z(double S, double varS) {
        if (S < 0.0) {
            return (S + 1.0) / Math.sqrt(varS);
        }
        if (S > 0.0) {
            return (S - 1.0) / Math.sqrt(varS);
        }
        return 0.0;
    }

    private static double p(double z) {
        NormalDistribution normDist = new NormalDistribution();
        return 2.0 * (1.0 - normDist.cumulativeProbability(Math.abs(z)));
    }

    private static double varS(double g, double[] x) {
        double n = x.length;
        return (2.0 * n + 5.0) / 18.0 * (n - 1.0) * n - g;
    }

    private static double g(Map<Double, Integer> xFreq) {
        double g = 0.0;
        for (Integer freq : xFreq.values()) {
            if (freq <= 1) continue;
            g += (double)freq.intValue() * ((double)freq.intValue() - 1.0) * (2.0 * (double)freq.intValue() + 5.0) / 18.0;
        }
        return g;
    }

    private static double S(double[] x) {
        double S = 0.0;
        for (int i = 0; i < x.length; ++i) {
            for (int j = i + 1; j < x.length; ++j) {
                S += Math.signum(x[j] - x[i]);
            }
        }
        return S;
    }

    private static double tau(double S, double[] x) {
        return S / (double)CombinatoricsUtils.binomialCoefficient((int)x.length, (int)2);
    }

    public double[] getX() {
        return this.x;
    }

    public double getTau() {
        return this.tau;
    }

    public double getS() {
        return this.S;
    }

    public double getVarS() {
        return this.varS;
    }

    public double getG() {
        return this.g;
    }

    public double getZ() {
        return this.z;
    }

    public double getP() {
        return this.p;
    }
}

