/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.util;

import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.utils.Tuple;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class TextDateNames {
    private static int[] QUARTERS = new int[]{1, 2, 3, 4};
    private static final int DEFAULT_MAX_LOCALES = 30;
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static int maxLocales = 30;
    private LinkedHashMap<TimeConcept, Map<String, Tuple<Integer, TextForm>>> conceptMap = new LinkedHashMap();
    private static final LinkedHashMap<Locale, TextDateNames> cache = new LinkedHashMap<Locale, TextDateNames>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > maxLocales;
        }
    };

    private TextDateNames(Locale locale) {
        TimeConcept[] concepts = new TimeConcept[]{TimeConcept.DAY_OF_WEEK, TimeConcept.MONTH, TimeConcept.QUARTER};
        Stream.of(concepts).forEach(m -> TextDateNames.putConceptsInMap(this.conceptMap, m, locale));
    }

    public static TextDateNamesItem findDateItem(String name, TimeConcept concept, Locale ... locales) {
        Locale[] adjustedLocales = TextDateNames.prePopulateCache(locales);
        String lowerCaseName = name.toLowerCase();
        Optional<Object> match = Optional.empty();
        for (Locale locale : adjustedLocales) {
            match = TextDateNames.findNameIndex(lowerCaseName, concept, locale);
            if (!match.isPresent()) continue;
            return new TextDateNamesItem((Integer)((Tuple)match.get())._1, TextDateNames.getCase(name), locale, (TextForm)((Object)((Tuple)match.get())._2), name);
        }
        return null;
    }

    public static List<String> getConceptLabels(TimeConcept concept, Locale locale, TextForm form) {
        TextDateNames.prePopulateCache(new Locale[]{locale});
        Optional<List<String>> labels = TextDateNames.findListOfConceptLabels(concept, locale, form);
        if (labels.isPresent()) {
            return labels.get();
        }
        return null;
    }

    public static Locale getDefaultLocale() {
        return DEFAULT_LOCALE;
    }

    private static Locale[] prePopulateCache(Locale[] locales) {
        Locale[] adjustedLocales = TextDateNames.addDefaultLocaleIfNotPresent(locales);
        Stream.of(adjustedLocales).forEach(m -> TextDateNames.cacheValues(m));
        return adjustedLocales;
    }

    private static Locale[] addDefaultLocaleIfNotPresent(Locale[] locales) {
        boolean foundDefaultLocale = Stream.of(locales).anyMatch(i -> i.equals(DEFAULT_LOCALE));
        if (foundDefaultLocale) {
            return locales;
        }
        int length = locales.length;
        Locale[] adjustedLocales = new Locale[length + 1];
        System.arraycopy(locales, 0, adjustedLocales, 0, length);
        adjustedLocales[length] = DEFAULT_LOCALE;
        return adjustedLocales;
    }

    private static void putConceptsInMap(LinkedHashMap<TimeConcept, Map<String, Tuple<Integer, TextForm>>> localeConcepts, TimeConcept concept, Locale locale) {
        DateFormatSymbols dateFormat = DateFormatSymbols.getInstance(locale);
        HashMap<String, Tuple<Integer, TextForm>> singleConceptMap = new HashMap<String, Tuple<Integer, TextForm>>();
        if (concept == TimeConcept.DAY_OF_WEEK) {
            List<String> longWeekDays = TextDateNames.getMasterListOfDateText(dateFormat.getWeekdays());
            List<String> shortWeekDays = TextDateNames.getMasterListOfDateText(dateFormat.getShortWeekdays());
            TextDateNames.putDateTextInMap(longWeekDays, singleConceptMap, TextForm.LONG);
            TextDateNames.putDateTextInMap(shortWeekDays, singleConceptMap, TextForm.SHORT);
            localeConcepts.put(TimeConcept.DAY_OF_WEEK, singleConceptMap);
        } else if (concept == TimeConcept.MONTH) {
            List<String> longMonths = TextDateNames.getMasterListOfDateText(dateFormat.getMonths());
            List<String> shortMonths = TextDateNames.getMasterListOfDateText(dateFormat.getShortMonths());
            TextDateNames.putDateTextInMap(longMonths, singleConceptMap, TextForm.LONG);
            TextDateNames.putDateTextInMap(shortMonths, singleConceptMap, TextForm.SHORT);
            localeConcepts.put(TimeConcept.MONTH, singleConceptMap);
        } else if (concept == TimeConcept.QUARTER) {
            List<String> quartersX = Arrays.stream(QUARTERS).mapToObj(x -> TextDateNames.getQuarterLabel(true, x)).collect(Collectors.toList());
            List<String> quartersQ = Arrays.stream(QUARTERS).mapToObj(x -> TextDateNames.getQuarterLabel(false, x)).collect(Collectors.toList());
            TextDateNames.putDateTextInMap(quartersX, singleConceptMap, TextForm.EITHER);
            TextDateNames.putDateTextInMap(quartersQ, singleConceptMap, TextForm.EITHER);
            localeConcepts.put(TimeConcept.QUARTER, singleConceptMap);
        }
    }

    private static Optional<Tuple<Integer, TextForm>> findNameIndex(String name, TimeConcept concept, Locale locale) {
        Map<String, Tuple<Integer, TextForm>> namesMap = TextDateNames.getNamesMap(concept, locale);
        if (namesMap == null) {
            return Optional.empty();
        }
        if (namesMap.containsKey(name)) {
            return Optional.of(namesMap.get(name));
        }
        return Optional.empty();
    }

    private static Optional<List<String>> findListOfConceptLabels(TimeConcept concept, Locale locale, TextForm form) {
        Map<String, Tuple<Integer, TextForm>> namesMap = TextDateNames.getNamesMap(concept, locale);
        if (namesMap == null) {
            return Optional.empty();
        }
        List labelsForConcept = namesMap.entrySet().stream().filter(item -> TextDateNames.isRequestedForm((TextForm)((Object)((Object)((Tuple)item.getValue())._2)), form)).sorted(Comparator.comparingInt(p -> (Integer)((Tuple)p.getValue())._1)).map(x -> (String)x.getKey()).collect(Collectors.toList());
        return Optional.of(labelsForConcept);
    }

    private static boolean isRequestedForm(TextForm currentForm, TextForm form) {
        return currentForm.equals((Object)form) || currentForm.equals((Object)TextForm.EITHER);
    }

    private static synchronized Map<String, Tuple<Integer, TextForm>> getNamesMap(TimeConcept concept, Locale locale) {
        if (cache.containsKey(locale)) {
            TextDateNames names = cache.get(locale);
            if (names.conceptMap.containsKey((Object)concept)) {
                return names.conceptMap.get((Object)concept);
            }
        }
        return null;
    }

    private static synchronized void cacheValues(Locale locale) {
        if (!cache.containsKey(locale)) {
            TextDateNames dateNames = new TextDateNames(locale);
            cache.put(locale, dateNames);
        }
    }

    private static List<String> getMasterListOfDateText(String[] dateText) {
        return Arrays.asList(dateText).stream().filter(label -> !StringUtils.isEmpty((CharSequence)label)).map(String::toLowerCase).collect(Collectors.toList());
    }

    private static void putDateTextInMap(List<String> labels, Map<String, Tuple<Integer, TextForm>> labelMap, TextForm form) {
        IntStream.range(0, labels.size()).forEach(x -> labelMap.put((String)labels.get(x), (Tuple<Integer, TextForm>)Tuple.of((Object)x, (Object)((Object)TextDateNames.adjustForEither((String)labels.get(x), labelMap, form)))));
    }

    private static String getQuarterLabel(boolean prefix, int quarterYear) {
        String quarterText = "q";
        if (prefix) {
            return quarterText + quarterYear;
        }
        return quarterYear + quarterText;
    }

    private static TextForm adjustForEither(String label, Map<String, Tuple<Integer, TextForm>> labelMap, TextForm form) {
        boolean foundLabel = Stream.of(labelMap).anyMatch(i -> i.containsKey(label));
        if (foundLabel) {
            return TextForm.EITHER;
        }
        return form;
    }

    private static MatchCase getCase(String stringValue) {
        if (com.ibm.bi.predict.utils.StringUtils.isAllLowerCaseIgnoreNumeric((String)stringValue)) {
            return MatchCase.LOWER;
        }
        if (com.ibm.bi.predict.utils.StringUtils.isAllUpperCaseIgnoreNumeric((String)stringValue)) {
            return MatchCase.UPPER;
        }
        return MatchCase.MIXED;
    }

    protected static void setMaxLocales(int maxLocales) {
        TextDateNames.maxLocales = maxLocales;
    }

    protected static void clearCache() {
        cache.clear();
    }

    protected static List<Locale> getCacheLocales() {
        return new ArrayList<Locale>(cache.keySet());
    }

    public static class TextDateNamesItem {
        private Integer index;
        private MatchCase matchCase;
        private Locale locale;
        private TextForm textForm;
        private String label;

        public TextDateNamesItem(Integer index, MatchCase matchCase, Locale locale, TextForm textForm, String label) {
            this.index = index;
            this.locale = locale;
            this.matchCase = matchCase;
            this.textForm = textForm;
            this.label = label;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public MatchCase getMatchCase() {
            return this.matchCase;
        }

        public Integer getIndex() {
            return this.index;
        }

        public TextForm getTextForm() {
            return this.textForm;
        }

        public String getLabel() {
            return this.label;
        }
    }

    protected static enum MatchCase {
        UPPER,
        LOWER,
        MIXED;

    }

    public static enum TextForm {
        EITHER,
        LONG,
        SHORT;

    }
}

