/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.summaries;

import com.spss.math.statistics.Power;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.util.Precision;

public class Median {
    private static final double DELTA = 1.0E-15;

    private Median() {
    }

    public static double compute(List<Double> values, List<Double> weights) {
        double count;
        int index;
        List<Double> cleanValues = Median.clean(values);
        List<Double> cleanWeights = Median.clean(weights);
        double totalRecordsCount = Median.getTotalRecordCount(cleanWeights);
        double totalRecordsCountRemainder = totalRecordsCount % 2.0;
        double halfWeight = totalRecordsCount / 2.0;
        double cumWeight = 0.0;
        Integer[] sortedIdxs = Median.getSortedValueIndexes(cleanValues);
        for (index = 0; index < cleanWeights.size() && !((cumWeight += (count = cleanWeights.get(sortedIdxs[index]).doubleValue())) >= halfWeight); ++index) {
        }
        ArrayList<Double> copy = new ArrayList<Double>(cleanValues);
        Collections.sort(copy);
        if (Precision.equals((double)totalRecordsCountRemainder, (double)0.0, (double)1.0E-15)) {
            if (Power.almostEqual((double)cumWeight, (double)halfWeight, (double)1.0)) {
                return ((Double)copy.get(index) + (Double)copy.get(index + 1)) / 2.0;
            }
            return (Double)copy.get(index);
        }
        return (Double)copy.get(index);
    }

    public static double compute(double[] values, double[] weights) {
        return Median.compute(Median.asList(values), Median.asList(weights));
    }

    private static List<Double> asList(double[] values) {
        ArrayList<Double> list = new ArrayList<Double>(values.length);
        for (double v : values) {
            list.add(v);
        }
        return list;
    }

    public static double compute(List<Double> values) {
        ArrayList<Double> defaultWeights = new ArrayList<Double>(Collections.nCopies(values.size(), 1.0));
        return Median.compute(values, defaultWeights);
    }

    private static List<Double> clean(List<Double> l) {
        return l.stream().filter(v -> !v.isNaN()).collect(Collectors.toList());
    }

    private static double getTotalRecordCount(List<Double> values) {
        return values.stream().filter(v -> !v.isNaN()).mapToDouble(Double::doubleValue).sum();
    }

    private static Integer[] getSortedValueIndexes(List<Double> data) {
        Integer[] idxs = (Integer[])IntStream.range(0, data.size()).boxed().toArray(Integer[]::new);
        Arrays.sort(idxs, (i1, i2) -> Double.compare((Double)data.get((int)i1), (Double)data.get((int)i2)));
        return idxs;
    }
}

