/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.table;

import com.ibm.bi.predict.algorithms.table.AdjustedCountR2;
import com.ibm.bi.predict.algorithms.table.FrequencyChiSquareTest;
import com.ibm.bi.predict.algorithms.table.results.ChiSquareTestResult;
import com.ibm.bi.predict.data.matrix.Matrix;
import com.ibm.bi.predict.data.matrix.MatrixVectorFactory;
import com.spss.ac.acmath.accumstats.AccumStats4InteractTests;
import com.spss.ac.acmath.accumstats.AccumTestStats4CatTarget;
import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseRectMatrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractChiSquareTestForCategTarget
implements AccumTestStats4CatTarget {
    private static final long serialVersionUID = -2820527608332678619L;
    final Matrix data;
    final int nTargetCategs;
    final int nFactor1Categs;
    final int nFactor2Categs;
    int nCells = 0;
    final int targetX;
    final int factor1X;
    final int factor2X;
    final int nRows;
    int validUpdCnt = 0;
    int invalidUpdCnt = 0;
    double totalNRecs = 0.0;
    double validNRecs = 0.0;
    final int weightX;
    protected ChiSquareTestResult results = null;
    private double accuracy = MissingValue.getMissing();
    HashMap<Double, Integer> targetCategoryMappings = new HashMap();
    HashMap<Double, Integer> factor1CategoryMappings = new HashMap();
    HashMap<Double, Integer> factor2CategoryMappings = new HashMap();
    private static final int MINIMUM_NUMBER_OF_FACTOR_CATEGORY = 2;
    private double threshold = 0.0;
    protected double adjustedValue;
    private int minCategoryFrequency;
    private AdjustedCountR2 acr2;

    public AbstractChiSquareTestForCategTarget(int nTargetCategs, int nFactor1Categs, int nFactor2Categs, int targetX, int factor1X, int factor2X, int nRows, int weightX, double threshold, int minCategoryFrequency) {
        this.nTargetCategs = nTargetCategs;
        this.nFactor1Categs = nFactor1Categs;
        this.nFactor2Categs = nFactor2Categs;
        this.targetX = targetX;
        this.factor1X = factor1X;
        this.factor2X = factor2X;
        this.nCells = nFactor1Categs * nFactor2Categs;
        this.data = MatrixVectorFactory.makeMatrix((int)nTargetCategs, (int)this.nCells, (int)nRows);
        this.nRows = nRows;
        this.weightX = weightX;
        this.threshold = threshold;
        this.minCategoryFrequency = minCategoryFrequency;
    }

    public double computeStatistics() {
        if (this.nCells >= 2) {
            FrequencyChiSquareTest cs = new FrequencyChiSquareTest(this.data, AbstractChiSquareTestForCategTarget.getAdjustValue(this.data, this.threshold));
            this.results = cs.computeOverallChiSquare();
        }
        this.acr2 = new AdjustedCountR2(this.data, this.minCategoryFrequency);
        this.accuracy = this.acr2.getAccuracy();
        return this.getPValue();
    }

    public double getPValue() {
        if (this.results != null) {
            return this.results.pValue;
        }
        return Double.NaN;
    }

    public double getFitMeasure() {
        return this.accuracy;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public double getEffectSize() {
        if (this.results != null) {
            return this.results.effectSize;
        }
        return Double.NaN;
    }

    public int getTargetIndex() {
        return this.targetX;
    }

    public double getChiSquare() {
        if (this.results != null) {
            return this.results.chiSquareStatistic;
        }
        return Double.NaN;
    }

    public int getWeightIndex() {
        return this.weightX;
    }

    public double getTotalNRecs() {
        return this.totalNRecs;
    }

    public double getValidNRecs() {
        return this.validNRecs;
    }

    public int getValidUpdCnt() {
        return this.validUpdCnt;
    }

    public int getInvalidUpdCnt() {
        return this.invalidUpdCnt;
    }

    public void addMissingCounts(double unweightedMissCount, double weightedMissCount) {
        this.invalidUpdCnt += (int)unweightedMissCount;
        this.totalNRecs += weightedMissCount;
    }

    public double[] getNRecsTargetCateg() {
        return this.data.rowTotals();
    }

    public double[] getNRecsFactorCateg() {
        return this.data.columnTotals();
    }

    public int getNTargetCategs() {
        return this.nTargetCategs;
    }

    public int getNFactorCategs() {
        return this.nCells;
    }

    public boolean merge(AccumStats4InteractTests var1) {
        return false;
    }

    public boolean merge(List<? extends AccumStats4InteractTests> var1) {
        return false;
    }

    public double getInterestingness() {
        return 0.0;
    }

    public void setInterestingness(double var1) {
    }

    public int[] getCovariateIndices() {
        return null;
    }

    public int compareTo(AccumStats4InteractTests var1) {
        return 0;
    }

    public Object readObject(DataInput arg0) throws IOException {
        return null;
    }

    public void writeObject(DataOutput arg0) throws IOException {
    }

    public DenseRectMatrix getNRecs() {
        return null;
    }

    public DenseRectMatrix getObsProbs() {
        return null;
    }

    public DenseRectMatrix getExpectedNRecs() {
        return null;
    }

    public int getUnweightedNRecs() {
        return 0;
    }

    public int[] getValidTargetCateg() {
        return null;
    }

    public double getLFull() {
        return 0.0;
    }

    public double getLReduced() {
        return 0.0;
    }

    public double getDF() {
        return 0.0;
    }

    public double getMcFaddenR2() {
        return 0.0;
    }

    public void setAggregatedStatistics(double[] var1, double[] var2, double[] var3, int var4, int var5, double var6, double var8) {
    }

    public double getAdjustedR2() {
        return this.acr2.getAdjustedCountR2();
    }

    protected int getCategoryIdx(double catValue, Map<Double, Integer> mapping) {
        if (mapping.get(catValue) == null) {
            mapping.put(catValue, mapping.size());
        }
        return mapping.get(catValue);
    }

    public static double getAdjustValue(Matrix data, double threshold) {
        double minExp = AbstractChiSquareTestForCategTarget.getMinimumExpected(data);
        return Math.max(threshold - minExp, 0.0);
    }

    private static double getMinimumExpected(Matrix data) {
        double minExpected = Double.MAX_VALUE;
        int rDim = data.rowDimension();
        int cDim = data.columnDimension();
        for (int r = 0; r < rDim; ++r) {
            for (int c = 0; c < cDim; ++c) {
                double exp = AbstractChiSquareTestForCategTarget.getExpected(r, c, data);
                if (!(exp > 0.0) || !(exp < minExpected)) continue;
                minExpected = exp;
            }
        }
        return minExpected;
    }

    private static double getExpected(int row, int column, Matrix data) {
        if (data.is2DMatrix()) {
            return data.rowTotal(row) * data.columnTotal(column) / data.sum();
        }
        if (!data.isOneByOneMatrix()) {
            return data.rowDimension() > 1 ? data.sum() / (double)data.rowDimension() : data.sum() / (double)data.columnDimension();
        }
        return data.sum();
    }
}

