/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.table;

import com.ibm.bi.predict.algorithms.table.results.ChiSquareTestResult;
import com.ibm.bi.predict.data.matrix.Matrix;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.spss.math.statistics.DistributionFunctions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public abstract class ChiSquareTest {
    private static final Logger log = PredictLoggerFactory.getLogger(ChiSquareTest.class);
    protected Matrix data;

    public ChiSquareTest(Matrix data) {
        this.data = data;
    }

    public ChiSquareTestResult computeOverallChiSquare() {
        return this.computeOverallStatistics(this.getChiSquareComputation());
    }

    public List<ChiSquareTestResult> computeChiSquareStatisticsForCells() {
        log.debug("Computing chi square statistics for cells");
        log.perfStart();
        ArrayList<ChiSquareTestResult> results = new ArrayList<ChiSquareTestResult>();
        AtomicBoolean effectSizeNeedsRescaling = new AtomicBoolean(false);
        this.data.walkAll((row, col, val) -> this.addResult(row, col, val, results, effectSizeNeedsRescaling));
        log.perfLog("Finished computing chi square statistics for cells");
        if (effectSizeNeedsRescaling.get()) {
            return this.getRescaledResults(results);
        }
        log.perfStop();
        return results;
    }

    private void addResult(int row, int col, double val, List<ChiSquareTestResult> results, AtomicBoolean effectSizeNeedsRescaling) {
        double cellChiSquareStat = this.computeChiSquareForCell(row, col, val);
        if (Double.isNaN(cellChiSquareStat) || Double.isInfinite(cellChiSquareStat)) {
            return;
        }
        double effectSize = this.computeEffectSizeForCell(row, col, cellChiSquareStat);
        if (effectSize > 1.0) {
            effectSizeNeedsRescaling.set(true);
        }
        double pValue = 1.0 - this.cdfChi(cellChiSquareStat, 1.0);
        double adjustedPValue = this.getAdjustedPValue(pValue);
        double cramersV = -1.0;
        double expectedValue = this.computeExpectedValueForCell(row, col, val);
        results.add(new ChiSquareTestResult(row, col, cellChiSquareStat, effectSize, cramersV, expectedValue, adjustedPValue));
    }

    protected abstract Matrix.EntryFunction getChiSquareComputation();

    protected abstract Matrix.EntryFunction getChiSquareCellComputation();

    protected abstract Matrix.EntryFunction getEffectSizeCellComputation();

    protected abstract Matrix.EntryFunction getExpectedValueComputation();

    private List<ChiSquareTestResult> getRescaledResults(List<ChiSquareTestResult> unscaledResults) {
        double maxEffectSize = this.getMaxEffectSize(unscaledResults);
        log.perfLog("Rescaling results");
        List<ChiSquareTestResult> scaledResults = unscaledResults.stream().map(result -> new ChiSquareTestResult(result.responseFieldIndex, result.explanatoryFieldIndex, result.chiSquareStatistic, result.effectSize / maxEffectSize, result.cramersv, result.expectedCount, result.pValue)).collect(Collectors.toList());
        log.perfLog("Finished rescaling results");
        log.perfStop();
        return scaledResults;
    }

    private double getMaxEffectSize(List<ChiSquareTestResult> results) {
        return results.stream().max(Comparator.comparingDouble(r -> r.effectSize)).map(r -> r.effectSize).get();
    }

    private ChiSquareTestResult computeOverallStatistics(Matrix.EntryFunction fn) {
        log.debug("Computing overall chi square statistics");
        log.perfStart();
        double chiSquareStat = this.computeChiSquareStatistic(fn);
        double pValue = 1.0 - this.cdfChi(chiSquareStat, this.getDegreesOfFreedom());
        double effectSize = this.phi(chiSquareStat, this.data.sum());
        double cramersV = this.cramersV(chiSquareStat, this.data.sum(), this.data.rowDimension(), this.data.columnDimension());
        log.perfStop();
        return new ChiSquareTestResult(chiSquareStat, effectSize, cramersV, pValue);
    }

    private int getDegreesOfFreedom() {
        if (this.data.is2DMatrix()) {
            return (this.data.rowDimension() - 1) * (this.data.columnDimension() - 1);
        }
        if (!this.data.isOneByOneMatrix()) {
            return this.data.rowDimension() > 1 ? this.data.rowDimension() - 1 : this.data.columnDimension() - 1;
        }
        return 0;
    }

    private double computeChiSquareForCell(int row, int col, double val) {
        double multFactor;
        double unnormalized = this.getChiSquareCellComputation().apply(row, col, val);
        if (this.data.is2DMatrix()) {
            multFactor = 1.0 / ((1.0 - this.data.rowTotal(row) / this.data.sum()) * (1.0 - this.data.columnTotal(col) / this.data.sum()));
        } else if (!this.data.isOneByOneMatrix()) {
            double innerDivisor = this.data.rowDimension() > 1 ? (double)this.data.rowDimension() : (double)this.data.columnDimension();
            multFactor = 1.0 / (1.0 - 1.0 / innerDivisor);
        } else {
            return Double.NaN;
        }
        return unnormalized * multFactor;
    }

    private double computeEffectSizeForCell(int row, int col, double chiSquareStatistic) {
        return this.getEffectSizeCellComputation().apply(row, col, chiSquareStatistic);
    }

    private double computeExpectedValueForCell(int row, int col, double val) {
        return this.getExpectedValueComputation().apply(row, col, val);
    }

    private double computeChiSquareStatistic(Matrix.EntryFunction fn) {
        double chiSquareStat = this.data.sumAll(fn);
        log.perfLog("Finished computing chi-square stat");
        return chiSquareStat;
    }

    private double cdfChi(double chiSquareStat, double degreesOfFreedom) {
        return Double.isNaN(chiSquareStat) ? Double.NaN : DistributionFunctions.cdfChi((double)chiSquareStat, (double)degreesOfFreedom);
    }

    private double getAdjustedPValue(double pValue) {
        return pValue * (double)this.data.rowDimension() * (double)this.data.columnDimension();
    }

    private double phi(double chiSquareStat, double totalRecords) {
        return Math.sqrt(chiSquareStat / totalRecords);
    }

    private double cramersV(double chiSquareStat, double totalRecords, int numberOfRows, int numberOfCols) {
        if ((double)numberOfCols <= 1.0) {
            return 0.0;
        }
        double rtilde = (double)numberOfRows - (double)((numberOfRows - 1) * (numberOfRows - 1)) / (totalRecords - 1.0);
        double ctilde = (double)numberOfCols - (double)((numberOfCols - 1) * (numberOfCols - 1)) / (totalRecords - 1.0);
        if (rtilde <= 1.0 || ctilde <= 1.0) {
            return 0.0;
        }
        double phitildeplus = Math.max(0.0, chiSquareStat / totalRecords - (double)((numberOfRows - 1) * (numberOfCols - 1)) / (totalRecords - 1.0));
        return Math.min(Math.sqrt(phitildeplus / Math.min(rtilde - 1.0, ctilde - 1.0)), 1.0);
    }
}

