/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.table;

import com.ibm.bi.predict.algorithms.table.ChiSquareTest;
import com.ibm.bi.predict.data.matrix.Matrix;
import com.ibm.bi.predict.math.NumericUtils;

public class FrequencyChiSquareTest
extends ChiSquareTest {
    private double adjustValue = 0.0;
    private Matrix.EntryFunction chiSquareComputation = (row, col, val) -> {
        double expected = this.getExpected(row, col);
        if (NumericUtils.equals((double)expected, (double)0.0)) {
            return 0.0;
        }
        return Math.pow(val - expected, 2.0) / (expected + this.adjustValue);
    };

    public FrequencyChiSquareTest(Matrix frequencies) {
        this(frequencies, 0.0);
    }

    public FrequencyChiSquareTest(Matrix frequencies, double adjustValue) {
        super(frequencies);
        if (adjustValue > 0.0) {
            this.adjustValue = adjustValue;
        }
    }

    @Override
    protected Matrix.EntryFunction getChiSquareComputation() {
        return this.chiSquareComputation;
    }

    @Override
    protected Matrix.EntryFunction getChiSquareCellComputation() {
        return this.chiSquareComputation;
    }

    @Override
    protected Matrix.EntryFunction getExpectedValueComputation() {
        return (row, col, value) -> this.getExpected(row, col);
    }

    @Override
    protected Matrix.EntryFunction getEffectSizeCellComputation() {
        return (row, col, cellChiSquareStat) -> Math.sqrt(cellChiSquareStat / this.data.sum());
    }

    private double getExpected(int row, int column) {
        if (this.data.is2DMatrix()) {
            return this.data.rowTotal(row) * this.data.columnTotal(column) / this.data.sum();
        }
        if (!this.data.isOneByOneMatrix()) {
            return this.data.rowDimension() > 1 ? this.data.sum() / (double)this.data.rowDimension() : this.data.sum() / (double)this.data.columnDimension();
        }
        return this.data.sum();
    }
}

