/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.table;

import com.ibm.bi.predict.algorithms.table.ChiSquareTest;
import com.ibm.bi.predict.data.matrix.Matrix;

public class NonFrequencyChiSquareTest
extends ChiSquareTest {
    private double averageValue = this.averageValue();
    private double averageDistance = this.averageDistance(this.averageValue);
    private double totalDistance = 0.0;
    private Matrix.EntryFunction chiSquareComputation = (row, col, val) -> {
        double distance = Math.abs(val - this.averageValue);
        return Math.pow(distance, 2.0) / this.averageDistance;
    };

    public NonFrequencyChiSquareTest(Matrix values) {
        super(values);
        this.initialize();
    }

    private void initialize() {
        this.setTotalDistance();
    }

    private void setTotalDistance() {
        double sumForNonZero;
        this.totalDistance = sumForNonZero = this.data.sumNonZero((r, c, val) -> Math.abs(val - this.averageValue));
    }

    @Override
    protected Matrix.EntryFunction getChiSquareComputation() {
        return this.chiSquareComputation;
    }

    @Override
    protected Matrix.EntryFunction getChiSquareCellComputation() {
        return this.chiSquareComputation;
    }

    @Override
    protected Matrix.EntryFunction getEffectSizeCellComputation() {
        return (row, col, cellChiSquareStat) -> Math.sqrt(cellChiSquareStat / this.totalDistance);
    }

    @Override
    protected Matrix.EntryFunction getExpectedValueComputation() {
        return (row, col, val) -> this.averageValue;
    }

    private double averageValue() {
        return this.data.sum() / (double)this.getNumberOfCategories();
    }

    private int getNumberOfCategories() {
        if (this.data.is2DMatrix()) {
            return this.data.rowDimension() * this.data.columnDimension();
        }
        if (!this.data.isOneByOneMatrix()) {
            return this.data.rowDimension() > 1 ? this.data.rowDimension() : this.data.columnDimension();
        }
        return 1;
    }

    private double averageDistance(double averageValue) {
        double summedDistance = this.data.sumNonZero((r, c, val) -> Math.abs(val - averageValue));
        return summedDistance / (double)this.getNumberOfCategories();
    }
}

