/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.table;

import com.ibm.bi.predict.algorithms.ThreeLevelScale;
import com.ibm.bi.predict.algorithms.summaries.Means;
import com.ibm.bi.predict.algorithms.table.results.AnovaResult;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.spss.math.statistics.DistributionFunctions;
import java.util.List;

public class OneWayAnova {
    private static final Logger log = PredictLoggerFactory.getLogger(OneWayAnova.class);
    public static final double SIGNIFICANCE_LEVEL = 0.05;
    public static final double ADJ_R2_THRESHOLD_VALUE = 0.1;
    private final List<Double> values;
    private final List<Double> counts;
    private final List<Double> sumOfSquares;
    private double mean = 0.0;
    private double pValue = Double.NaN;
    private double effectSize = 0.0;
    private double adjustedRSquared = 0.0;
    private ThreeLevelScale associationStrengthLevel;
    private double fStatistic = Double.NaN;
    private double withinSumOfSquares;
    private double betweenSumOfSquares;
    private double totalSumOfSquares;

    public OneWayAnova(List<Double> values, List<Double> counts, List<Double> sumOfSquares) {
        this(values, counts, sumOfSquares, 0.0);
        this.mean = OneWayAnova.calculateMean(values, counts);
    }

    public OneWayAnova(List<Double> values, List<Double> counts, List<Double> sumOfSquares, double mean) {
        this.values = values;
        this.counts = counts;
        this.sumOfSquares = sumOfSquares;
        this.mean = mean;
    }

    public AnovaResult compute() {
        double totalRecordCount = this.getTotalRecordCount();
        double withinDf = totalRecordCount - this.totalCategories();
        this.withinSumOfSquares = this.withinSumOfSquares();
        double meanSquareWithin = this.withinSumOfSquares / withinDf;
        double betweenDf = this.totalCategories() - 1.0;
        this.betweenSumOfSquares = this.betweenSumOfSquares();
        double meanSquareBetween = this.betweenSumOfSquares / betweenDf;
        this.calculateFStatisticAndPValue(withinDf, meanSquareWithin, betweenDf, meanSquareBetween);
        this.adjustedRSquared = this.calculateAdjustedRSquared(this.withinSumOfSquares, withinDf, this.betweenSumOfSquares);
        if (!Double.isNaN(this.pValue) && this.pValue <= 0.05 && this.adjustedRSquared > 0.1) {
            this.totalSumOfSquares = this.betweenSumOfSquares + this.withinSumOfSquares;
            this.effectSize = this.betweenSumOfSquares / this.totalSumOfSquares;
            log.debug("Factor is significant - pValue={} effectSize={} adjR2={}", new Object[]{this.pValue, this.effectSize, this.adjustedRSquared});
            this.associationStrengthLevel = OneWayAnova.calculateStrengthLevel(this.adjustedRSquared);
            return new AnovaResult(this.pValue, this.effectSize, this.adjustedRSquared, this.fStatistic, this.associationStrengthLevel);
        }
        return new AnovaResult(this.pValue, 0.0, this.adjustedRSquared, this.fStatistic, null);
    }

    public static ThreeLevelScale calculateStrengthLevel(double adjRSquared) {
        if (adjRSquared <= 0.35) {
            return ThreeLevelScale.LOW;
        }
        if (adjRSquared <= 0.7) {
            return ThreeLevelScale.MEDIUM;
        }
        return ThreeLevelScale.HIGH;
    }

    public double getPValue() {
        return this.pValue;
    }

    public ThreeLevelScale getStrengthLevel() {
        return this.associationStrengthLevel;
    }

    public double getEffectSize() {
        return this.effectSize;
    }

    public double getAdjustedRSquared() {
        return this.adjustedRSquared;
    }

    public double getFStatistic() {
        return this.fStatistic;
    }

    public double getFactorSumOfSquares() {
        return (this.totalSumOfSquares - this.withinSumOfSquares) / this.totalSumOfSquares;
    }

    public double getTotalSumOfSquares() {
        return this.betweenSumOfSquares + this.withinSumOfSquares;
    }

    private void calculateFStatisticAndPValue(double withinDf, double meanSquareWithin, double betweenDf, double meanSquareBetween) {
        if (this.withinSumOfSquares > 0.0 && withinDf > 0.0 && betweenDf > 0.0) {
            this.fStatistic = meanSquareBetween / meanSquareWithin;
            log.debug("Computed F-ratio - f-ratio={} meanSquareBetween={} meanSquareWithin={}", new Object[]{this.fStatistic, meanSquareBetween, meanSquareWithin});
            double cdfF = OneWayAnova.cdfF(this.fStatistic, betweenDf, withinDf);
            this.pValue = 1.0 - cdfF;
        } else {
            this.fStatistic = Double.NaN;
            this.pValue = this.withinSumOfSquares < 1.0E-12 && this.betweenSumOfSquares >= 1.0E-12 ? 0.0 : Double.NaN;
        }
    }

    private double calculateAdjustedRSquared(double withinSumOfSquares, double withinDf, double betweenSumOfSquares) {
        double SSt = betweenSumOfSquares + withinSumOfSquares;
        if (SSt > 0.0 && withinSumOfSquares > 0.0 && withinDf > 0.0) {
            double SStDf = this.getTotalRecordCount() - 1.0;
            return 1.0 - withinSumOfSquares / withinDf / (SSt / SStDf);
        }
        return 1.0;
    }

    private static double cdfF(double fStatistic, double betweenDf, double withinDf) {
        return Double.isNaN(fStatistic) ? 0.0 : DistributionFunctions.cdfF((double)fStatistic, (double)betweenDf, (double)withinDf);
    }

    private double withinSumOfSquares() {
        return this.sumDoubleList(this.sumOfSquares);
    }

    private double betweenSumOfSquares() {
        double tSumOfSquares = 0.0;
        for (int i = 0; i < this.values.size(); ++i) {
            double value = this.values.get(i);
            double count = this.counts.get(i);
            tSumOfSquares += count * Math.pow(value - this.mean, 2.0);
        }
        return tSumOfSquares;
    }

    private double getTotalRecordCount() {
        return this.sumDoubleList(this.counts);
    }

    private double totalCategories() {
        return this.values.size();
    }

    private double sumDoubleList(List<Double> l) {
        return l.stream().mapToDouble(Double::doubleValue).sum();
    }

    private static double calculateMean(List<Double> values, List<Double> counts) {
        return Means.weightedMean(NumericUtils.listToDoubleArray(values), NumericUtils.listToDoubleArray(counts));
    }
}

