/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.table;

import com.ibm.bi.predict.algorithms.table.AbstractChiSquareTestForCategTarget;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.spss.math.MissingValue;

public class OnewayChiSquareTestForCategTarget
extends AbstractChiSquareTestForCategTarget {
    private static final long serialVersionUID = -4478239828704672858L;
    private static final Logger log = PredictLoggerFactory.getLogger(OnewayChiSquareTestForCategTarget.class);

    public OnewayChiSquareTestForCategTarget(int nTargetCategs, int nFactorCategs, int targetX, int factorX, int nRows) {
        this(nTargetCategs, nFactorCategs, targetX, factorX, nRows, -1);
    }

    public OnewayChiSquareTestForCategTarget(int nTargetCategs, int nFactorCategs, int targetX, int factorX, int nRows, int weightX) {
        this(nTargetCategs, nFactorCategs, targetX, factorX, nRows, weightX, 0.0);
    }

    public OnewayChiSquareTestForCategTarget(int nTargetCategs, int nFactorCategs, int targetX, int factorX, int nRows, int weightX, double threshold) {
        this(nTargetCategs, nFactorCategs, targetX, factorX, nRows, weightX, threshold, 0);
    }

    public OnewayChiSquareTestForCategTarget(int nTargetCategs, int nFactorCategs, int targetX, int factorX, int nRows, int weightX, double threshold, int minCategoryFrequency) {
        super(nTargetCategs, nFactorCategs, 1, targetX, factorX, -1, nRows, weightX, threshold, minCategoryFrequency);
    }

    @Override
    public double computeStatistics() {
        log.perfStart();
        double pvalue = super.computeStatistics();
        double chisqV = this.results != null ? this.results.chiSquareStatistic : Double.NaN;
        String msg = String.format("Finished computing categorical target statistics: chisquare value {%.4f}, adjusted value {%.4f}, target category {%d}, factor category {%d}, rows {%d}", chisqV, this.adjustedValue, this.nTargetCategs, this.nFactor1Categs, this.nRows);
        log.perfLog(msg);
        log.perfStop();
        return pvalue;
    }

    public boolean update(double[] record, boolean validateFactorVal) {
        double targetValueD = record[this.targetX];
        double factor1ValueD = record[this.factor1X];
        double weight = this.weightX >= 0 ? record[this.weightX] : 1.0;
        boolean hasResult = true;
        if (validateFactorVal) {
            hasResult = !MissingValue.isMissing((double)targetValueD) && !MissingValue.isMissing((double)factor1ValueD);
        }
        int targetValue = 0;
        int factor1Value = 0;
        if (hasResult) {
            targetValue = this.getCategoryIdx(targetValueD, this.targetCategoryMappings);
            factor1Value = this.getCategoryIdx(factor1ValueD, this.factor1CategoryMappings);
            boolean bl = hasResult = targetValue >= 0 && targetValue < this.nTargetCategs && factor1Value >= 0 && factor1Value < this.nFactor1Categs;
        }
        if (hasResult) {
            this.data.increment(targetValue, factor1Value, weight);
            ++this.validUpdCnt;
            this.totalNRecs += weight;
            this.validNRecs += weight;
        } else {
            ++this.invalidUpdCnt;
            if (weight > 0.0) {
                this.totalNRecs += weight;
            }
        }
        return hasResult;
    }

    public int[] getFactorIndices() {
        int[] result = new int[]{this.factor1X};
        return result;
    }
}

