/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.table;

import com.ibm.bi.predict.data.matrix.Matrix;
import com.ibm.bi.predict.math.NumericUtils;
import java.util.Arrays;

public class TableStatistics {
    private TableStatistics() {
    }

    public static double tau(Matrix table) {
        double N = table.sum();
        double A = table.sumNonZero((i, k, Nik) -> Nik * Nik / table.columnTotal(k));
        double B = Arrays.stream(table.rowTotals()).map(x -> x * x).sum();
        double denominator = N * N - B;
        if (NumericUtils.isZero((double)denominator)) {
            return Double.NaN;
        }
        return (N * A - B) / denominator;
    }
}

