/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.table;

import com.ibm.bi.predict.algorithms.table.AbstractChiSquareTestForCategTarget;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.spss.math.MissingValue;

public class TwowayChiSquareTestForCategTarget
extends AbstractChiSquareTestForCategTarget {
    private static final long serialVersionUID = -1508190408740795928L;
    private static final Logger log = PredictLoggerFactory.getLogger(TwowayChiSquareTestForCategTarget.class);

    public TwowayChiSquareTestForCategTarget(int nTargetCategs, int nFactor1Categs, int nFactor2Categs, int targetX, int factor1X, int factor2X, int nRows) {
        this(nTargetCategs, nFactor1Categs, nFactor2Categs, targetX, factor1X, factor2X, nRows, -1);
    }

    public TwowayChiSquareTestForCategTarget(int nTargetCategs, int nFactor1Categs, int nFactor2Categs, int targetX, int factor1X, int factor2X, int nRows, int weightX) {
        this(nTargetCategs, nFactor1Categs, nFactor2Categs, targetX, factor1X, factor2X, nRows, weightX, 0.0);
    }

    public TwowayChiSquareTestForCategTarget(int nTargetCategs, int nFactor1Categs, int nFactor2Categs, int targetX, int factor1X, int factor2X, int nRows, int weightX, double threshold) {
        this(nTargetCategs, nFactor1Categs, nFactor2Categs, targetX, factor1X, factor2X, nRows, weightX, threshold, 0);
    }

    public TwowayChiSquareTestForCategTarget(int nTargetCategs, int nFactor1Categs, int nFactor2Categs, int targetX, int factor1X, int factor2X, int nRows, int weightX, double threshold, int minCategoryFrequency) {
        super(nTargetCategs, nFactor1Categs, nFactor2Categs, targetX, factor1X, factor2X, nRows, weightX, threshold, minCategoryFrequency);
    }

    @Override
    public double computeStatistics() {
        log.perfStart();
        double pvalue = super.computeStatistics();
        double chisqV = this.results != null ? this.results.chiSquareStatistic : Double.NaN;
        String msg = String.format("Finished computing categorical target statistics: chisquare value {%.4f}, adjusted value {%.4f}, target category {%d}, factor 1 category {%d}, factor 2 category {%d}, rows {%d}", chisqV, this.adjustedValue, this.nTargetCategs, this.nFactor1Categs, this.nFactor2Categs, this.nRows);
        log.perfLog(msg);
        log.perfStop();
        return pvalue;
    }

    public boolean update(double[] record, boolean validateFactorVal) {
        double targetValueD = record[this.targetX];
        double factor1ValueD = record[this.factor1X];
        double factor2ValueD = record[this.factor2X];
        double weight = this.weightX >= 0 ? record[this.weightX] : 1.0;
        boolean hasResult = true;
        if (validateFactorVal) {
            hasResult = !MissingValue.isMissing((double)targetValueD) && !MissingValue.isMissing((double)factor1ValueD) && !MissingValue.isMissing((double)factor2ValueD);
        }
        int targetValue = 0;
        int factor1Value = 0;
        int factor2Value = 0;
        if (hasResult) {
            targetValue = this.getCategoryIdx(targetValueD, this.targetCategoryMappings);
            factor1Value = this.getCategoryIdx(factor1ValueD, this.factor1CategoryMappings);
            factor2Value = this.getCategoryIdx(factor2ValueD, this.factor2CategoryMappings);
            boolean bl = hasResult = targetValue >= 0 && targetValue < this.nTargetCategs && factor1Value >= 0 && factor1Value < this.nFactor1Categs && factor2Value >= 0 && factor2Value < this.nFactor2Categs;
        }
        if (hasResult) {
            int cellX = factor1Value * this.nFactor2Categs + factor2Value;
            this.data.increment(targetValue, cellX, weight);
            ++this.validUpdCnt;
            this.totalNRecs += weight;
            this.validNRecs += weight;
        } else {
            ++this.invalidUpdCnt;
            if (weight > 0.0) {
                this.totalNRecs += weight;
            }
        }
        return hasResult;
    }

    public int[] getFactorIndices() {
        int[] result = new int[]{this.factor1X, this.factor2X};
        return result;
    }
}

