/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.tree.summary;

import com.ibm.bi.predict.algorithms.tree.summary.SummaryStats;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.fastpattern.util.IntList;

class ContinuousSummaryStats
extends SummaryStats {
    private double mean;
    private double sumSquares;

    ContinuousSummaryStats(DataColumn target, IntList rows) {
        super(target, rows.len());
        double mk = target.getValue(rows.value(0));
        double vk = 0.0;
        for (int k = 1; k < rows.len(); ++k) {
            double xk = target.getValue(rows.value(k));
            double dx = xk - mk;
            vk += (xk - (mk += dx / (double)(k + 1))) * dx;
        }
        this.mean = mk;
        this.sumSquares = vk;
    }

    private ContinuousSummaryStats(DataColumn target, int len) {
        super(target, len);
    }

    @Override
    public int[] categoryFrequencies() {
        throw new UnsupportedOperationException("Cannot return category counts for a continuous target");
    }

    @Override
    public double expectedValue() {
        return this.mean;
    }

    @Override
    public double impurity() {
        return this.sumSquares / (double)this.n;
    }

    @Override
    public double totalImpurity() {
        return this.sumSquares;
    }

    @Override
    public double std() {
        return Math.sqrt(this.sumSquares / (double)(this.n - 1));
    }

    public String toString() {
        return String.format("mean=%6.2f, sd=%6.2f, #rows=%d", this.mean, this.std(), this.n);
    }

    @Override
    public SummaryStats merge(SummaryStats other) {
        int n1 = this.n();
        int n2 = other.n();
        double mean1 = this.expectedValue();
        double mean2 = other.expectedValue();
        ContinuousSummaryStats otherStats = (ContinuousSummaryStats)other;
        ContinuousSummaryStats combStats = new ContinuousSummaryStats(this.target, n1 + n2);
        combStats.mean = (mean1 * (double)n1 + mean2 * (double)n2) / (double)combStats.n;
        combStats.sumSquares = this.totalImpurity() + otherStats.totalImpurity() + (double)n1 * (mean1 - combStats.mean) * (mean1 - combStats.mean) + (double)n2 * (mean2 - combStats.mean) * (mean2 - combStats.mean);
        return combStats;
    }
}

