/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.tree.testutilities;

import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.data.DataPrep;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class LabelGenerator {
    public static final LabelGenerator SIMPLE = new LabelGenerator();
    private final Map<String, String[]> namesMap = new LinkedHashMap<String, String[]>();
    private static final List<String> ORDINALS = Arrays.asList("first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth", "tenth");
    private static final String[][] BINNED = new String[][]{new String[0], {"any"}, {"lower", "higher"}, {"low", "middle", "high"}, {"lowest", "lower", "higher", "highest"}, {"lowest", "low", "middle", "high", "highest"}};

    private LabelGenerator() {
    }

    public static LabelGenerator makeFor(DataAccessProvider dataAccess) {
        LabelGenerator generator = new LabelGenerator();
        generator.useDataAccess(dataAccess);
        return generator;
    }

    public static LabelGenerator makeFor(DataPrep prep) {
        LabelGenerator generator = new LabelGenerator();
        generator.useDataPrep(prep);
        return generator;
    }

    private void useDataPrep(DataPrep prep) {
        Stream.concat(prep.driverColumns().stream(), Stream.of(prep.targetColumn())).filter(column -> column.getType() == FieldType.CATEGORICAL || column.hasStatus(DataColumn.Status.BINNED)).forEach(column -> this.namesMap.put(column.getId(), LabelGenerator.getFieldCategoryLabels(column)));
    }

    private void useDataAccess(DataAccessProvider dataAccess) {
        MetaData metaData = dataAccess.getMetaData();
        for (int i = 0; i < metaData.fieldCount(); ++i) {
            if (metaData.getFieldType(i) != FieldType.CATEGORICAL) continue;
            this.namesMap.put(metaData.getFieldIdentifier(i), LabelGenerator.getFieldCategoryLabels(metaData, i));
        }
    }

    private static String[] getFieldCategoryLabels(DataColumn column) {
        int nCats = column.getCategoryCount();
        String[] names = new String[nCats];
        for (int i = 0; i < nCats; ++i) {
            names[i] = ((Category)column.getCategories().get(i)).toString();
        }
        return names;
    }

    private static String[] getFieldCategoryLabels(MetaData metaData, int columnIndex) {
        int nCats = metaData.getFieldCategories(columnIndex);
        String[] names = new String[nCats];
        for (int i = 0; i < nCats; ++i) {
            names[i] = metaData.getFieldCategoryLabel(columnIndex, i);
        }
        return names;
    }

    static String[] binnedDataNames(DataColumn column) {
        if (!column.hasStatus(DataColumn.Status.BINNED)) {
            throw new IllegalArgumentException("This method generates labels for binned data");
        }
        ArrayList<String> labels = new ArrayList<String>();
        int trueCategoryCount = LabelGenerator.getTrueCategoryCount(column);
        if (trueCategoryCount > 10) {
            return (String[])IntStream.rangeClosed(1, trueCategoryCount).mapToObj(i -> i + "/" + trueCategoryCount).toArray(String[]::new);
        }
        if (trueCategoryCount > 5) {
            labels.addAll(ORDINALS.subList(0, trueCategoryCount));
        } else {
            Collections.addAll(labels, BINNED[trueCategoryCount]);
        }
        if (column.hasStatus(DataColumn.Status.ZERO_INFLATED)) {
            labels.add(0, "zero");
        }
        if (column.hasStatus(DataColumn.Status.ADDED_MISSING)) {
            labels.add("missing");
        }
        return labels.toArray(new String[labels.size()]);
    }

    private static int getTrueCategoryCount(DataColumn column) {
        int trueCategoryCount = column.getCategoryCount();
        if (column.hasStatus(DataColumn.Status.ADDED_MISSING)) {
            --trueCategoryCount;
        }
        if (column.hasStatus(DataColumn.Status.ZERO_INFLATED)) {
            --trueCategoryCount;
        }
        return trueCategoryCount;
    }

    public String nameOf(DataColumn column, Double value) {
        if (this.namesMap.containsKey(column.getId())) {
            return this.nameOfCategoricalColumnValue(column, value);
        }
        if (column.getType() == FieldType.DATETIME) {
            return LabelGenerator.nameOfDateColumnValue(value);
        }
        return this.nameOfNumericColumnValue(column, value);
    }

    private String nameOfNumericColumnValue(DataColumn column, Double value) {
        if (column.hasStatus(DataColumn.Status.BINNED)) {
            String[] knownLabels = this.namesMap.computeIfAbsent(column.getId(), c -> LabelGenerator.binnedDataNames(column));
            return knownLabels[value.intValue()];
        }
        return Double.toString(value);
    }

    private static String nameOfDateColumnValue(Double value) {
        return new Date(value.longValue()).toString();
    }

    private String nameOfCategoricalColumnValue(DataColumn column, Double value) {
        String[] knownLabels = this.namesMap.get(column.getId());
        if (knownLabels == null) {
            return "category_" + value.intValue();
        }
        if (column.getCategoryCount() == knownLabels.length) {
            return knownLabels[value.intValue()];
        }
        throw new IllegalStateException("Problem");
    }
}

