/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.testutils;

import com.ibm.bi.predict.algorithms.forecasting.ForecastingAlgorithmContext;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.models.ModelBuilder;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeIndexMapper;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.utils.Tuple;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;

public class TimeSeriesTestUtils {
    public static SeriesResult generateSeriesResult(double[] y, boolean findOutliers, double periodSize) {
        return TimeSeriesTestUtils.generateSeriesResultWithTimeDimension(y, TimeSeriesTestUtils.generateTimeDimension(TimeConcept.YEAR, y.length), findOutliers, periodSize);
    }

    public static SeriesResult generateSeriesResultWithTimeDimension(double[] y, TimeDimension timeDimension, boolean findOutliers, double periodSize) {
        TimeIndexMapper mockMapper = new TimeIndexMapper(timeDimension, TimeSeriesTestUtils.makeCategoricalColumn("A", "", y, ""));
        timeDimension.setTimeIndexMapper(mockMapper);
        String seriesId = "123";
        String seriesLabel = "series A";
        String categoryA = "A";
        SeriesResult sr = new SeriesResult(seriesId, seriesLabel, new int[]{0}, new String[]{categoryA}).setHistoricalValues(y).setMissingValueIndices(Collections.emptySet()).setForecastOffset(0);
        ForecastingAlgorithmContext context = new ForecastingAlgorithmContext();
        context.setTimeDimension(timeDimension);
        context.setValue("forecast.config.includeOutliers", findOutliers);
        if (periodSize > 0.0) {
            context.setValue("forecast.config.seasonalityPeriod", periodSize);
        }
        ModelBuilder mb = new ModelBuilder(context);
        sr = mb.fit(sr, Optional.of(0));
        return sr;
    }

    public static TimeDimension generateTimeDimension(TimeConcept timeConcept, int length) {
        double[] ints = new double[length];
        String[] times = new String[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = i;
            times[i] = Integer.toString(i + 1);
        }
        DataColumn column = TimeSeriesTestUtils.makeCategoricalColumn(timeConcept.toString(), timeConcept.id(), ints, times);
        return TimeDimension.makeForColumns(Locale.ENGLISH, column);
    }

    public static TimeDimension generateTimestampTimeDimension(int amountToAdd, TimeConcept timeConcept, int length) {
        double[] ints = new double[length];
        String[] times = new String[length];
        LocalDateTime time = LocalDateTime.of(1970, 1, 1, 1, 1, 1);
        for (int i = 0; i < length; ++i) {
            ints[i] = i;
            times[i] = time.toString();
            time = time.plus(amountToAdd, timeConcept.getUnit().getChronoUnit());
        }
        DataColumn column = TimeSeriesTestUtils.makeCategoricalColumn("datetime", TimeConcept.DATETIME.id(), ints, times);
        return TimeDimension.makeForColumns(Locale.ENGLISH, column);
    }

    public static DataColumn makeCategoricalColumn(String label, String conceptID, double[] data, String ... categories) {
        return TimeSeriesTestUtils.makeCategoricalColumn(label, conceptID, 0.0, data, categories);
    }

    static DataColumn makeCategoricalColumn(String label, String conceptID, double conceptConfidence, double[] data, String ... categories) {
        DataColumn.ColumnMeta columnMeta = new DataColumn.ColumnMeta(label, label, FieldType.CATEGORICAL, AggregationType.NONE, Collections.singletonList(Tuple.of((Object)conceptID, (Object)conceptConfidence)));
        ArrayList<Category> categoryList = new ArrayList<Category>();
        for (String category : categories) {
            categoryList.add(Category.forString((String)category));
        }
        return new DataColumn(columnMeta, categoryList, data);
    }
}

