/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation;

import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.sa.execution.annotation.Annotation;
import com.ibm.bi.predict.sa.execution.annotation.AnnotationFactory;
import com.ibm.bi.predict.sa.execution.annotation.impl.AnovaAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.CategoricalTargetChiSquareAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.FitLineAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.FitRatioAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.MeanAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.ModeAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.OneWayChiSquareAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.StudentizedResidualsAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.TwoWayAnovaAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.TwoWayChiSquareAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.UnivariateTimeSeriesAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.UnusualCellDetectionAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.WeightedMeanAnnotation;
import com.ibm.bi.predict.sa.execution.api.MetaDataAdapter;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.sa.execution.statistic.AlgorithmStatisticName;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AnnotationFactoryImpl
implements AnnotationFactory {
    private static final Logger log = PredictLoggerFactory.getLogger(AnnotationFactoryImpl.class);
    private Map<AlgorithmStatisticName, Class<? extends Annotation<?>>> annotations = new EnumMap(AlgorithmStatisticName.class);

    public AnnotationFactoryImpl() {
        this.annotations.put(AlgorithmStatisticName.MEAN, MeanAnnotation.class);
        this.annotations.put(AlgorithmStatisticName.ONE_WAY_CHI_SQUARE, OneWayChiSquareAnnotation.class);
        this.annotations.put(AlgorithmStatisticName.WEIGHTED_MEAN, WeightedMeanAnnotation.class);
        this.annotations.put(AlgorithmStatisticName.ANOVA, AnovaAnnotation.class);
        this.annotations.put(AlgorithmStatisticName.UNUSUAL_CELL_DETECTION, UnusualCellDetectionAnnotation.class);
        this.annotations.put(AlgorithmStatisticName.CATEGORICAL_TARGET_CHISQUARE, CategoricalTargetChiSquareAnnotation.class);
        this.annotations.put(AlgorithmStatisticName.TWO_WAY_CHI_SQUARE, TwoWayChiSquareAnnotation.class);
        this.annotations.put(AlgorithmStatisticName.FIT_LINE, FitLineAnnotation.class);
        this.annotations.put(AlgorithmStatisticName.STUDENTIZED_RESIDUALS, StudentizedResidualsAnnotation.class);
        this.annotations.put(AlgorithmStatisticName.FIT_RATIO, FitRatioAnnotation.class);
        this.annotations.put(AlgorithmStatisticName.TWO_WAY_ANOVA, TwoWayAnovaAnnotation.class);
        this.annotations.put(AlgorithmStatisticName.MODE, ModeAnnotation.class);
        this.annotations.put(AlgorithmStatisticName.UNIVARIATE_TIME_SERIES, UnivariateTimeSeriesAnnotation.class);
    }

    @Override
    public Optional<Annotation<?>> getAnnotation(String annotationType, MetaDataAdapter metadata) throws InstantiationException, IllegalAccessException {
        AlgorithmStatisticName type = AlgorithmStatisticName.fromString(annotationType);
        if (type == null) {
            log.warn("Unknown annotation type. Cannot create annotation - type={}", (Object)annotationType);
            return Optional.empty();
        }
        try {
            return Optional.of(this.annotations.get((Object)type).getDeclaredConstructor(MetaDataAdapter.class).newInstance(metadata));
        }
        catch (Exception e) {
            log.warn("Could not generate annotation for {} due to error: {}", new Object[]{type, e.getMessage(), e});
            return Optional.empty();
        }
    }

    @Override
    public Map<SuggestedAnnotation, Annotation<?>> getAnnotationsFromSuggestions(Set<SuggestedAnnotation> suggestions, MetaData metadata) throws InstantiationException, IllegalAccessException {
        log.debug("Generating annotations from suggestions");
        LinkedHashMap map = new LinkedHashMap();
        for (SuggestedAnnotation suggested : suggestions) {
            Optional<Annotation<?>> ann = this.getAnnotation(suggested.algorithm, new MetaDataAdapter(metadata, suggested));
            if (!ann.isPresent()) {
                log.warn("Received empty annotation. Cannot execute annotation - algorithm={}", (Object)suggested.algorithm);
                continue;
            }
            map.put(suggested, ann.get());
        }
        String annotationNames = map.values().stream().map(a -> a.getClass().getSimpleName()).collect(Collectors.joining(","));
        log.debug("Preparing to execute annotations - annotations={}", (Object)annotationNames);
        return map;
    }
}

