/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.decorations;

import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.sa.execution.annotation.DecorationStrategy;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.FitLineResult;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class FitLineDecoration
implements DecorationStrategy<List<FitLineResult.FitLineData>> {
    private static final Logger log = PredictLoggerFactory.getLogger(FitLineDecoration.class);
    private int targetIndex;
    private static final String[] coefficientNames = new String[]{"a", "b", "c"};

    public FitLineDecoration(int targetIndex, MessageService messages) {
        this.targetIndex = targetIndex;
    }

    @Override
    public void decorate(Decorator decorator, AnnotationResult<List<FitLineResult.FitLineData>> result, Locale locale) {
        if (!result.isEmpty()) {
            List<FitLineResult.FitLineData> data = result.getResult();
            decorator.decorateColumn(this.targetIndex, "fitLine", this.getCoefficientsDecoration(data, locale));
            decorator.decorateColumn(this.targetIndex, "tooltip", FitLineDecoration.getTooltip(data, locale));
        }
    }

    private String getCoefficientsDecoration(List<FitLineResult.FitLineData> result, Locale locale) {
        JSONArray out = new JSONArray();
        result.forEach(f -> out.add((Object)this.getFitLineObj((FitLineResult.FitLineData)f)));
        return out.toString();
    }

    private JSONObject getFitLineObj(FitLineResult.FitLineData f) {
        JSONObject fitLineObj = new JSONObject();
        try {
            if (f.categoryName != null) {
                fitLineObj.put("category", (Object)this.getStringOrEmpty(f.categoryName));
            }
            if (f.categoryIdentifier != null) {
                fitLineObj.put("categoryId", (Object)this.getStringOrEmpty(f.categoryIdentifier));
            }
            fitLineObj.put("explanatoryName", (Object)f.explanatoryName);
            for (int i = 0; i < f.coefficients.length; ++i) {
                fitLineObj.put(coefficientNames[i], f.coefficients[i]);
            }
            fitLineObj.put("m", 0);
        }
        catch (JSONException e) {
            log.error("IllegalDataAccessRequest during attempt to write fit line decoration");
            throw new IllegalDataAccessRequest("Attempting to put bad values to JSONObject", (Throwable)e);
        }
        return fitLineObj;
    }

    private String getStringOrEmpty(String s) {
        return "PREDICTNOVALUECAT_4847aaa3-2eac-4489-b1d8-1ebc8146f1aa_PREDICTNOVALUECAT".equals(s) ? "" : s;
    }

    private static String getTooltip(List<FitLineResult.FitLineData> fitLineData, Locale locale) {
        return fitLineData.stream().map(d -> d.equation.getEquation(locale)).collect(Collectors.joining("; "));
    }
}

