/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.decorations;

import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.math.NumberFormatter;
import com.ibm.bi.predict.sa.execution.annotation.DecorationStrategy;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.MeaningfulDifferencesResult;
import java.util.List;
import java.util.Locale;

public class MeaningfulDifferencesDecoration
implements DecorationStrategy<List<MeaningfulDifferencesResult.MeaningfulDifferencesData>> {
    private static final String BUNDLE_NAME = "Predict_Smart_Annotations";
    private static final String UP = "up";
    private static final String DOWN = "down";
    private final int indexOfItemToBeDecorated;
    private final MessageService messages;
    private final AggregationType aggType;

    public MeaningfulDifferencesDecoration(int indexOfItemToBeDecorated, MessageService messages) {
        this(indexOfItemToBeDecorated, messages, null);
    }

    public MeaningfulDifferencesDecoration(int indexOfItemToBeDecorated, MessageService messages, AggregationType aggType) {
        this.indexOfItemToBeDecorated = indexOfItemToBeDecorated;
        this.messages = messages;
        this.aggType = aggType;
    }

    @Override
    public void decorate(Decorator decorator, AnnotationResult<List<MeaningfulDifferencesResult.MeaningfulDifferencesData>> result, Locale locale) {
        if (!result.isEmpty()) {
            result.getResult().forEach(i -> this.decorateCell(decorator, (MeaningfulDifferencesResult.MeaningfulDifferencesData)i, locale));
        }
    }

    private void decorateCell(Decorator decorator, MeaningfulDifferencesResult.MeaningfulDifferencesData cellIndexObj, Locale locale) {
        decorator.decorateCell(this.indexOfItemToBeDecorated, cellIndexObj.getCellIndex(), "keydriver", MeaningfulDifferencesDecoration.isHigh(cellIndexObj) ? UP : DOWN);
        decorator.decorateCell(this.indexOfItemToBeDecorated, cellIndexObj.getCellIndex(), "predict_outlier_expected_value", (Number)cellIndexObj.getOutlierExpectedValue());
        decorator.decorateCell(this.indexOfItemToBeDecorated, cellIndexObj.getCellIndex(), "predict_outlier_score", (Number)cellIndexObj.getOutlierMeasureValue());
        decorator.decorateCell(this.indexOfItemToBeDecorated, cellIndexObj.getCellIndex(), "tooltip", this.getTooltip(locale, cellIndexObj));
    }

    private String getTooltip(Locale locale, MeaningfulDifferencesResult.MeaningfulDifferencesData rowIndexObj) {
        MessageService.MessageBundle msgBundle = this.messages.getMessageBundle(BUNDLE_NAME, locale);
        String direction = rowIndexObj.getOutlierTypeValue().toUpperCase();
        if (this.aggType == AggregationType.COUNT) {
            return msgBundle.getMessage("MEANINGFUL_DIFFERENCES_DECO_EXPECTED_VALUE_LONG_" + direction, NumberFormatter.formatCount((Locale)locale, (boolean)true, (double)rowIndexObj.getOutlierExpectedValue()));
        }
        return msgBundle.getMessage("MEANINGFUL_DIFFERENCES_DECO_LONG_" + direction, new Object[0]);
    }

    private static boolean isHigh(MeaningfulDifferencesResult.MeaningfulDifferencesData cellIndexObj) {
        return "high".equalsIgnoreCase(cellIndexObj.getOutlierTypeValue());
    }
}

