/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.decorations;

import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.math.NumberFormatter;
import com.ibm.bi.predict.sa.execution.annotation.DecorationStrategy;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.OutlierResult;
import java.util.List;
import java.util.Locale;

public class OutlierDecoration
implements DecorationStrategy<List<OutlierResult.OutlierData>> {
    private static final String BUNDLE_NAME = "Predict_Smart_Annotations";
    private final int responseIndex;
    private final MessageService messages;

    public OutlierDecoration(int responseIndex, MessageService messageService) {
        this.responseIndex = responseIndex;
        this.messages = messageService;
    }

    @Override
    public void decorate(Decorator decorator, AnnotationResult<List<OutlierResult.OutlierData>> result, Locale locale) {
        if (!result.isEmpty()) {
            result.getResult().forEach(i -> this.decorateCell(decorator, (OutlierResult.OutlierData)i, locale));
        }
    }

    private void decorateCell(Decorator decorator, OutlierResult.OutlierData decoData, Locale locale) {
        int rowIndex = decoData.cellIdx;
        decorator.decorateCell(this.responseIndex, rowIndex, "keydriver", "significantlydifferent");
        decorator.decorateCell(this.responseIndex, rowIndex, "predict_outlier_score", (Number)decoData.outlierMeasureValue);
        decorator.decorateCell(this.responseIndex, rowIndex, "tooltip", this.getTooltip(locale, decoData));
    }

    private String getTooltip(Locale locale, OutlierResult.OutlierData decoData) {
        return this.messages.getMessageBundle(BUNDLE_NAME, locale).getMessage("OUTLIER_DECO_LONG_NUMERIC", decoData.responseName, OutlierDecoration.formatTooltipValue(locale, decoData.responseValue));
    }

    private static String formatTooltipValue(Locale locale, double value) {
        return NumberFormatter.format((Locale)locale, (boolean)true, (double)value);
    }
}

