/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.impl;

import com.ibm.bi.predict.algorithms.ThreeLevelScale;
import com.ibm.bi.predict.algorithms.table.OneWayAnova;
import com.ibm.bi.predict.algorithms.table.results.AnovaResult;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.sa.execution.annotation.ConditionalResponses;
import com.ibm.bi.predict.sa.execution.annotation.MessageServiceImpl;
import com.ibm.bi.predict.sa.execution.annotation.decorations.PredictiveStrengthDecoration;
import com.ibm.bi.predict.sa.execution.annotation.impl.OneWayAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.math.StatisticsMap;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.PredictiveStrengthResult;
import com.ibm.bi.predict.sa.execution.api.DataRowAdapter;
import com.ibm.bi.predict.sa.execution.api.MetaDataAdapter;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class AnovaAnnotation
extends OneWayAnnotation<PredictiveStrengthResult.PredictiveStrengthData> {
    private static final Logger log = PredictLoggerFactory.getLogger(AnovaAnnotation.class);
    private static final int MIN_CATS = 2;
    private int totalRecordCount = 0;
    private List<Double> values = new ArrayList<Double>();
    private List<Double> counts = new ArrayList<Double>();
    private List<Double> sumOfSquares = new ArrayList<Double>();
    private double anovaMean = 0.0;
    private double pValue = 0.0;
    private double effectSize = 0.0;
    private double adjustedRSquared = 0.0;
    private ThreeLevelScale associationStrengthLevel;

    public AnovaAnnotation(MetaDataAdapter metadata) {
        super(metadata);
    }

    @Override
    public void update(DataRowAdapter dataRow) {
        double value = dataRow.getTargetValue();
        double count = dataRow.getTargetStatistic(StatisticsMap.StatisticName.ROW_COUNT);
        double sumSqr = dataRow.getTargetStatistic(StatisticsMap.StatisticName.SUM_OF_SQUARES);
        this.values.add(value);
        this.counts.add(count);
        this.sumOfSquares.add(sumSqr);
        this.totalRecordCount += (int)count;
        this.anovaMean += count * value;
    }

    @Override
    public ConditionalResponse postUpdate() {
        if (this.totalRecordCount <= 0) {
            return ConditionalResponses.SUCCESS;
        }
        this.anovaMean /= (double)this.totalRecordCount;
        AnovaResult result = this.runAnova();
        this.pValue = result.pValue;
        this.effectSize = result.effectSize;
        this.adjustedRSquared = result.adjustedRSquared;
        this.associationStrengthLevel = result.strengthLevel;
        return ConditionalResponses.SUCCESS;
    }

    @Override
    public AnnotationResult<PredictiveStrengthResult.PredictiveStrengthData> buildResult() {
        return new PredictiveStrengthResult(new PredictiveStrengthResult.PredictiveStrengthData(this.pValue, this.effectSize, this.adjustedRSquared, this.associationStrengthLevel, this.metadata.getResponseName(), this.metadata.getNameOfFirstExplanatoryField()));
    }

    @Override
    public void decorate(Decorator decorator, SuggestedAnnotation annotationSuggestion, Locale locale) {
        new PredictiveStrengthDecoration(new MessageServiceImpl()).decorate(decorator, this.getResult(), locale);
    }

    @Override
    protected int minNumberOfCategories() {
        return 2;
    }

    private AnovaResult runAnova() {
        log.perfStart();
        log.perfLog("Starting ANOVA postUpdate");
        OneWayAnova anova = new OneWayAnova(this.values, this.counts, this.sumOfSquares, this.anovaMean);
        AnovaResult result = anova.compute();
        log.perfLog("Completed ANOVA postUpdate");
        log.perfStop();
        return result;
    }
}

