/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.impl;

import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.sa.execution.annotation.ConditionalResponses;
import com.ibm.bi.predict.sa.execution.annotation.impl.OneWayAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.ModeResult;
import com.ibm.bi.predict.sa.execution.api.DataRowAdapter;
import com.ibm.bi.predict.sa.execution.api.MetaDataAdapter;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ModeAnnotation
extends OneWayAnnotation<ModeResult.ModeData> {
    private static final int MIN_CATS = 1;
    private final int[] categoryCounts;

    public ModeAnnotation(MetaDataAdapter metadata) {
        super(metadata);
        this.categoryCounts = new int[metadata.getCountOfExplanatoryFieldCategories(0)];
    }

    @Override
    public void update(DataRowAdapter dataRow) {
        int cat;
        double cValue = dataRow.getExplanatoryValue();
        double rValue = dataRow.getTargetValue();
        if (!Double.isNaN(cValue) && !Double.isNaN(rValue) && (cat = (int)cValue) >= 0 && cat < this.categoryCounts.length) {
            int n = cat;
            this.categoryCounts[n] = this.categoryCounts[n] + (int)rValue;
        }
    }

    @Override
    public ConditionalResponse postUpdate() {
        return ConditionalResponses.SUCCESS;
    }

    @Override
    public AnnotationResult<ModeResult.ModeData> buildResult() {
        String explanatoryName = this.metadata.getNameOfExplanatoryField(0);
        ArrayList<String> categoryLabels = new ArrayList<String>();
        for (int i2 = 0; i2 < this.categoryCounts.length; ++i2) {
            categoryLabels.add(this.metadata.getCategoryNameOfExplanatoryField(0, i2));
        }
        int sum = 0;
        int maxc = 0;
        for (int i3 = 0; i3 < this.categoryCounts.length; ++i3) {
            int cc = this.categoryCounts[i3];
            sum += cc;
            if (cc <= maxc) continue;
            maxc = cc;
        }
        if (sum == 0) {
            return new ModeResult(ModeResult.ModeData.noResult(explanatoryName));
        }
        double percent = (double)maxc / (double)sum;
        int maxCount = maxc;
        List<String> labels = IntStream.range(0, this.categoryCounts.length).filter(i -> this.categoryCounts[i] == maxCount).mapToObj(categoryLabels::get).collect(Collectors.toList());
        return new ModeResult(new ModeResult.ModeData(explanatoryName, maxCount, percent, labels, categoryLabels.size() > 1 && labels.size() == categoryLabels.size()));
    }

    @Override
    public void decorate(Decorator decorator, SuggestedAnnotation annotationSuggestion, Locale locale) {
    }

    @Override
    protected int minNumberOfCategories() {
        return 1;
    }
}

