/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.impl;

import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingNoModelException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.IrregularDataException;
import com.ibm.bi.predict.algorithms.forecasting.hierarchy.Hierarchy;
import com.ibm.bi.predict.algorithms.forecasting.result.ColumnUpdater;
import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingResult;
import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingResultData;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.forecasting.ForecastingContext;
import com.ibm.bi.predict.forecasting.ForecastingIntegration;
import com.ibm.bi.predict.sa.execution.annotation.ConditionalResponses;
import com.ibm.bi.predict.sa.execution.annotation.FieldRole;
import com.ibm.bi.predict.sa.execution.annotation.MessageServiceImpl;
import com.ibm.bi.predict.sa.execution.annotation.decorations.TimeSeriesDecoration;
import com.ibm.bi.predict.sa.execution.annotation.impl.FullDataAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.response.ExecutionResultToConditionalResponses;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.TimeSeriesResult;
import com.ibm.bi.predict.sa.execution.api.MetaDataAdapter;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class UnivariateTimeSeriesAnnotation
extends FullDataAnnotation<List<TimeSeriesResult.TimeSeriesData>> {
    private static final Logger LOG = PredictLoggerFactory.getLogger(UnivariateTimeSeriesAnnotation.class);
    private final ForecastingIntegration forecastingService;
    private Map<List<Integer>, Integer> dataCellIndices;
    private ForecastingResult forecastingResult;
    private ForecastingResult successfulForecastingResults;

    public UnivariateTimeSeriesAnnotation(ForecastingIntegration forecastingService, MetaDataAdapter metadata) {
        super(metadata);
        this.forecastingService = forecastingService;
    }

    public UnivariateTimeSeriesAnnotation(MetaDataAdapter metadata) {
        this(ForecastingIntegration.getService(), metadata);
    }

    @Override
    public Set<ConditionalResponse> computeResult(DataAccessProvider dataProvider, Locale locale) {
        if (this.dataCellIndices == null) {
            this.dataCellIndices = UnivariateTimeSeriesAnnotation.setDataCellIndices(dataProvider, this.metadata);
        }
        if (this.moreThanOneTimeField()) {
            LOG.warn("Cannot handle multiple explanatory fields");
            return Collections.emptySet();
        }
        try {
            this.forecastingResult = this.forecastingService.runAlgorithms(dataProvider, this.createForecastContext(locale));
            this.successfulForecastingResults = new ForecastingResult(this.forecastingResult.getStatus(), ((ForecastingResultData)this.forecastingResult.getContent()).getSeriesResults().entrySet().stream().filter(v -> ((SeriesResult)v.getValue()).isForecastSuccessful()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), ((ForecastingResultData)this.forecastingResult.getContent()).getTimeDimension());
        }
        catch (ForecastingParametersException e) {
            LOG.warn("Error in input passed to forecasting service", (Throwable)e);
            return ExecutionResultToConditionalResponses.convertException((Exception)((Object)e));
        }
        catch (ForecastingNoModelException e) {
            LOG.warn("Forecasting model error", (Throwable)e);
            ConditionalResponse response = ConditionalResponses.FORECAST_SERVICE_NOMODEL_ERROR;
            return Collections.singleton(response);
        }
        catch (IrregularDataException e) {
            LOG.warn("Forecasting model error", (Throwable)e);
            ConditionalResponse response = ConditionalResponses.FORECAST_SERVICE_IRREGULAR_DATA;
            return Collections.singleton(response);
        }
        catch (Exception e) {
            LOG.warn("Forecast service internal error: " + e.getMessage(), (Throwable)e);
            ConditionalResponse response = ConditionalResponses.FORECAST_SERVICE_INTERNAL_ERROR;
            return Collections.singleton(response);
        }
        return ExecutionResultToConditionalResponses.convertResult(this.forecastingResult);
    }

    @Override
    public AnnotationResult<List<TimeSeriesResult.TimeSeriesData>> buildResult() {
        ArrayList<TimeSeriesResult.TimeSeriesData> tsData = new ArrayList<TimeSeriesResult.TimeSeriesData>();
        List seriesResults = ((ForecastingResultData)this.forecastingResult.getContent()).getOrderedSeriesResults();
        for (SeriesResult seriesResult : seriesResults) {
            List<TimeSeriesResult.ForecastedPoint> forecastedPoints = Collections.emptyList();
            if (seriesResult.isForecastSuccessful()) {
                forecastedPoints = Arrays.stream(seriesResult.getForecastValues()).map(fv -> {
                    String categoryLabel = String.join((CharSequence)"|", fv.getTime().getValues());
                    return new TimeSeriesResult.ForecastedPoint(fv.getValue(), fv.getUpperBound(), fv.getLowerBound(), categoryLabel);
                }).collect(Collectors.toList());
            }
            tsData.add(new TimeSeriesResult.TimeSeriesData(seriesResult, forecastedPoints));
        }
        return new TimeSeriesResult(tsData);
    }

    @Override
    public void decorate(Decorator decorator, SuggestedAnnotation suggestion, Locale locale) {
        new TimeSeriesDecoration(suggestion, this.metadata, new MessageServiceImpl(), this.dataCellIndices).decorate(decorator, this.getResult(), locale);
    }

    @Override
    public void addData(Decorator decorator, SuggestedAnnotation suggestion, Locale locale) {
        new TimeSeriesDecoration(suggestion, this.metadata, new MessageServiceImpl(), this.dataCellIndices).addData(decorator, this.getResult(), locale);
    }

    @Override
    public boolean sort(DataAccessProvider provider, Locale locale) {
        return provider.getDecorator().reorderRows(this.timeFieldIndex(), this.getRowOrder());
    }

    private int[] getRowOrder() {
        ColumnUpdater labelUpdater = new ColumnUpdater(this.successfulForecastingResults);
        TimeDimension time = labelUpdater.update();
        Set invalidRowIndices = time.getInvalidRowIndices();
        int[] rowOrder = time.newRowOrder();
        if (invalidRowIndices.isEmpty()) {
            return rowOrder;
        }
        return this.rowOrderWithInvalidIndices(rowOrder, invalidRowIndices);
    }

    private int[] rowOrderWithInvalidIndices(int[] rowOrder, Set<Integer> invalidRowIndices) {
        int size = rowOrder.length + invalidRowIndices.size();
        Map<Integer, Integer> rowOrderMap = this.mapRowOrderIndices(invalidRowIndices, size);
        return this.rowOrderIncludingInvalidIndices(rowOrder, invalidRowIndices, rowOrderMap);
    }

    private int[] rowOrderIncludingInvalidIndices(int[] rowOrder, Set<Integer> invalidRowIndices, Map<Integer, Integer> rowOrderMap) {
        ArrayList<Integer> newRowOrder = new ArrayList<Integer>(invalidRowIndices);
        newRowOrder.addAll(Arrays.stream(rowOrder).mapToObj(rowOrderMap::get).collect(Collectors.toList()));
        return newRowOrder.stream().mapToInt(i -> i).toArray();
    }

    private Map<Integer, Integer> mapRowOrderIndices(Set<Integer> invalidRowIndices, int size) {
        AtomicInteger rowOrderIndex = new AtomicInteger(0);
        return IntStream.range(0, size).boxed().filter(i -> !invalidRowIndices.contains(i)).collect(Collectors.toMap(i -> rowOrderIndex.getAndIncrement(), i -> i));
    }

    private ForecastingContext createForecastContext(Locale locale) {
        ForecastingContext context = new ForecastingContext();
        Map<String, Object> modelOptions = this.metadata.getModelOptions();
        context.setModelOptions(modelOptions);
        int explanatoryIndex = this.timeFieldIndex();
        Hierarchy timeHierarchy = new Hierarchy(this.metadata.getNameOfField(explanatoryIndex), new int[]{explanatoryIndex});
        Hierarchy[] seriesHierarchies = this.metadata.getIndexByRole(FieldRole.GROUP).map(groupIndex -> new Hierarchy[]{new Hierarchy(this.metadata.getNameOfField((int)groupIndex), new int[]{groupIndex})}).orElse(null);
        context.setSeriesHierarchies(seriesHierarchies);
        context.setTimeHierarchy(timeHierarchy);
        context.setValue("target", Arrays.asList(this.metadata.getResponseIndex()));
        context.setValue("releaseProvider", (Object)false);
        context.setValue("locale", (Object)locale.toString());
        return context;
    }

    static Map<List<Integer>, Integer> setDataCellIndices(DataAccessProvider dataProvider, MetaDataAdapter metaData) {
        HashMap<List<Integer>, Integer> dataCellIndices = new HashMap<List<Integer>, Integer>();
        DataIterator iterator = dataProvider.getDataIterator();
        int index = 0;
        while (iterator.hasNext()) {
            DataRow row = (DataRow)iterator.next();
            dataCellIndices.put(UnivariateTimeSeriesAnnotation.getIndices(row, metaData), index);
            ++index;
        }
        return dataCellIndices;
    }

    private static List<Integer> getIndices(DataRow row, MetaDataAdapter metaData) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        Optional<Integer> explanatoryIdx = metaData.getIndexByRole(FieldRole.EXPLANATORY);
        Optional<Integer> groupIdx = metaData.getIndexByRole(FieldRole.GROUP);
        if (explanatoryIdx.isPresent()) {
            indices.add((int)row.getValue(explanatoryIdx.get().intValue()));
        }
        if (groupIdx.isPresent()) {
            indices.add((int)row.getValue(groupIdx.get().intValue()));
        }
        return indices;
    }

    Map<List<Integer>, Integer> getDataCellIndices() {
        return this.dataCellIndices;
    }

    private boolean moreThanOneTimeField() {
        return this.metadata.getExplanatoryFieldIndices().size() > 1;
    }

    private int timeFieldIndex() {
        if (this.metadata.getExplanatoryFieldIndices().size() != 1) {
            LOG.error("Time series annotation request containing multiple explanatory field");
            throw new PredictException("Time series annotation request containing multiple explanatory field");
        }
        return this.metadata.getExplanatoryFieldIndices().get(0);
    }
}

