/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.impl;

import com.ibm.bi.predict.algorithms.ThreeLevelScale;
import com.ibm.bi.predict.algorithms.table.UnusualCellDetection;
import com.ibm.bi.predict.algorithms.table.results.InfluentialCategory;
import com.ibm.bi.predict.data.matrix.Matrix;
import com.ibm.bi.predict.data.matrix.MatrixVectorFactory;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.sa.execution.annotation.Annotation;
import com.ibm.bi.predict.sa.execution.annotation.ConditionalResponses;
import com.ibm.bi.predict.sa.execution.annotation.FieldRole;
import com.ibm.bi.predict.sa.execution.annotation.MessageServiceImpl;
import com.ibm.bi.predict.sa.execution.annotation.decorations.MeaningfulDifferencesDecoration;
import com.ibm.bi.predict.sa.execution.annotation.impl.math.StatisticsMap;
import com.ibm.bi.predict.sa.execution.annotation.impl.types.CategoryName;
import com.ibm.bi.predict.sa.execution.annotation.response.Conditional;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.EmptyResult;
import com.ibm.bi.predict.sa.execution.annotation.result.MeaningfulDifferencesResult;
import com.ibm.bi.predict.sa.execution.api.DataRowAdapter;
import com.ibm.bi.predict.sa.execution.api.MetaDataAdapter;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.utils.Tuple;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class UnusualCellDetectionAnnotation
extends Annotation<List<MeaningfulDifferencesResult.MeaningfulDifferencesData>>
implements Conditional {
    private static final int MIN_CATS_ONE_WAY = 3;
    private static final int MIN_CATS_TWO_WAY = 2;
    private final int factorAIndex = this.factorAIndex();
    private final int factorBIndex = this.factorBIndex();
    private long totalCount = 0L;
    private int numCategories;
    private List<InfluentialCategory> influentialCells;
    private Matrix values;
    private Matrix counts;
    private Matrix sumOfSquares;
    private Matrix indices;

    public UnusualCellDetectionAnnotation(MetaDataAdapter metadata) {
        super(metadata);
        this.values = MatrixVectorFactory.makeMatrix((int)this.factorACount(), (int)this.factorBCount(), (int)metadata.rowCount());
        this.counts = MatrixVectorFactory.makeMatrix((int)this.factorACount(), (int)this.factorBCount(), (int)metadata.rowCount());
        this.sumOfSquares = MatrixVectorFactory.makeMatrix((int)this.factorACount(), (int)this.factorBCount(), (int)metadata.rowCount());
        this.indices = MatrixVectorFactory.makeMatrix((int)this.factorACount(), (int)this.factorBCount(), (int)metadata.rowCount());
    }

    @Override
    public ConditionalResponse assertPreconditions() {
        if (!this.enoughCategories()) {
            return this.tooFewCategories();
        }
        return ConditionalResponses.SUCCESS;
    }

    @Override
    public void update(DataRowAdapter dataRow) {
        int factorBCategory;
        int factorACategory;
        double value = dataRow.getTargetValue();
        double count = dataRow.getTargetStatistic(StatisticsMap.StatisticName.ROW_COUNT);
        double sumSqr = dataRow.getTargetStatistic(StatisticsMap.StatisticName.SUM_OF_SQUARES);
        if (this.isTwoWay()) {
            factorACategory = (int)dataRow.getFieldValueByIndex(this.factorAIndex);
            factorBCategory = (int)dataRow.getFieldValueByIndex(this.factorBIndex);
        } else {
            factorACategory = 0;
            factorBCategory = (int)dataRow.getExplanatoryValue();
        }
        this.values.setValue(factorACategory, factorBCategory, value);
        this.counts.setValue(factorACategory, factorBCategory, count);
        this.sumOfSquares.setValue(factorACategory, factorBCategory, sumSqr);
        this.indices.setValue(factorACategory, factorBCategory, (double)dataRow.getDataRowIndex());
        this.totalCount = (long)((double)this.totalCount + count);
        ++this.numCategories;
    }

    @Override
    public ConditionalResponse postUpdate() {
        UnusualCellDetection cellDetection = !this.isOneWay() && this.shouldTreatAsOneWay() ? new UnusualCellDetection(this.values.transpose(), this.counts.transpose(), this.sumOfSquares.transpose(), this.totalCount, this.numCategories) : new UnusualCellDetection(this.values, this.counts, this.sumOfSquares, this.totalCount, this.numCategories);
        this.influentialCells = cellDetection.compute();
        return ConditionalResponses.SUCCESS;
    }

    @Override
    public AnnotationResult<List<MeaningfulDifferencesResult.MeaningfulDifferencesData>> buildResult() {
        if (this.influentialCells == null || this.influentialCells.isEmpty()) {
            return new EmptyResult<List<MeaningfulDifferencesResult.MeaningfulDifferencesData>>();
        }
        List<MeaningfulDifferencesResult.MeaningfulDifferencesData> results = this.influentialCells.stream().map(cell -> {
            String outlierType = cell.direction == ThreeLevelScale.HIGH ? "high" : "low";
            List<String> categoryNames = this.getCategoryNames((Tuple<Integer, Integer>)cell.categoryIndex);
            String responseName = this.metadata.getResponseName();
            List<String> factorNames = this.getFactorNames();
            return new MeaningfulDifferencesResult.MeaningfulDifferencesData(this.getCellIndex((InfluentialCategory)cell), outlierType, cell.expected, cell.pValue, CategoryName.fromList(categoryNames), responseName, factorNames, this.metadata.getAggregationTypeOfField(this.metadata.getResponseIndex()));
        }).collect(Collectors.toList());
        return new MeaningfulDifferencesResult(results);
    }

    @Override
    public void decorate(Decorator decorator, SuggestedAnnotation annotationSuggestion, Locale locale) {
        AnnotationResult<List<MeaningfulDifferencesResult.MeaningfulDifferencesData>> result = this.getResult();
        if (!result.isEmpty()) {
            int responseIndex = annotationSuggestion.indexOfTarget;
            new MeaningfulDifferencesDecoration(responseIndex, new MessageServiceImpl()).decorate(decorator, result, locale);
        }
    }

    private int getCellIndex(InfluentialCategory cell) {
        int factorBIndex;
        int factorAIndex;
        if (!this.isOneWay() && this.shouldTreatAsOneWay()) {
            factorAIndex = (Integer)cell.categoryIndex._2;
            factorBIndex = (Integer)cell.categoryIndex._1;
        } else {
            factorAIndex = (Integer)cell.categoryIndex._1;
            factorBIndex = (Integer)cell.categoryIndex._2;
        }
        return (int)this.indices.getValue(factorAIndex, factorBIndex);
    }

    private List<String> getFactorNames() {
        if (this.isTwoWay() && !this.shouldTreatAsOneWay()) {
            return Arrays.asList(this.metadata.getNameOfField(this.factorAIndex), this.metadata.getNameOfField(this.factorBIndex));
        }
        if (this.isTwoWay() && this.shouldTreatAsOneWay()) {
            return Arrays.asList(this.metadata.getNameOfField(this.factorBIndex), this.metadata.getNameOfField(this.factorAIndex));
        }
        return Arrays.asList(this.metadata.getNameOfField(this.factorAIndex));
    }

    private boolean enoughCategories() {
        if (this.isOneWay()) {
            return this.factorBCount() >= 3;
        }
        return this.hasEnoughCategoriesForTwoWay() || this.hasEnoughCategoriesForAPsuedoOneWay();
    }

    private List<String> getCategoryNames(Tuple<Integer, Integer> categoryIndexes) {
        if (this.isOneWay()) {
            return Arrays.asList(this.metadata.getCategoryNameForField(this.factorAIndex, (Integer)categoryIndexes._2));
        }
        if (this.shouldTreatAsOneWay()) {
            return Arrays.asList(this.metadata.getCategoryNameForField(this.factorAIndex, (Integer)categoryIndexes._2), this.metadata.getCategoryNameForField(this.factorBIndex, (Integer)categoryIndexes._1));
        }
        return Arrays.asList(this.metadata.getCategoryNameForField(this.factorAIndex, (Integer)categoryIndexes._1), this.metadata.getCategoryNameForField(this.factorBIndex, (Integer)categoryIndexes._2));
    }

    private boolean isOneWay() {
        return !this.isTwoWay();
    }

    private boolean shouldTreatAsOneWay() {
        return this.factorBCount() < 2;
    }

    private boolean hasEnoughCategoriesForTwoWay() {
        return this.factorACount() >= 2 && this.factorBCount() >= 2;
    }

    private boolean hasEnoughCategoriesForAPsuedoOneWay() {
        return this.factorACount() >= 3 || this.factorBCount() >= 3;
    }

    private ConditionalResponse tooFewCategories() {
        if (this.isOneWay()) {
            return ConditionalResponses.TOO_FEW_CATEGORIES(this.metadata.getNameOfField(this.factorAIndex));
        }
        if (this.metadata.getCountOfExplanatoryFieldCategories(0) >= 3) {
            return ConditionalResponses.TOO_FEW_CATEGORIES(this.metadata.getNameOfField(this.factorAIndex));
        }
        return ConditionalResponses.TOO_FEW_CATEGORIES(this.metadata.getNameOfField(this.factorBIndex));
    }

    private int factorACount() {
        return this.isTwoWay() ? this.metadata.getCountOfFieldCategories(this.factorAIndex) : 1;
    }

    private int factorBCount() {
        return this.isTwoWay() ? this.metadata.getCountOfFieldCategories(this.factorBIndex) : this.metadata.getCountOfFieldCategories(this.factorAIndex);
    }

    private int factorAIndex() {
        return this.metadata.getExplanatoryFieldIndices().get(0);
    }

    private int factorBIndex() {
        if (!this.isTwoWay()) {
            return 0;
        }
        List<Integer> explanatoryIndices = this.metadata.getExplanatoryFieldIndices();
        List<Integer> groupIndices = this.metadata.getFieldIndicesByRole(FieldRole.GROUP);
        if (explanatoryIndices.size() == 2) {
            return explanatoryIndices.get(1);
        }
        if (explanatoryIndices.size() == 1 && groupIndices.size() == 1) {
            return this.metadata.getFieldIndicesByRole(FieldRole.GROUP).get(0);
        }
        throw new PredictException("Unknown state. Expected 2 explanatory fields or 1 explanatory, 1 group");
    }

    private boolean isTwoWay() {
        return this.metadata.getNumberOfExplanatoryFields() == 2 || this.metadata.getNumberOfExplanatoryFields() == 1 && this.metadata.getFieldIndicesByRole(FieldRole.GROUP).size() == 1;
    }
}

