/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.impl;

import com.ibm.bi.predict.sa.execution.annotation.impl.MeanAnnotation;
import com.ibm.bi.predict.sa.execution.annotation.impl.math.StatisticsMap;
import com.ibm.bi.predict.sa.execution.api.DataRowAdapter;
import com.ibm.bi.predict.sa.execution.api.MetaDataAdapter;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class WeightedMeanAnnotation
extends MeanAnnotation {
    private int totalRecordCount = 0;
    private double weightedMean = 0.0;
    private double weightedTotal = 0.0;

    public WeightedMeanAnnotation(MetaDataAdapter metadata) {
        super(metadata);
    }

    @Override
    public void update(DataRowAdapter dataRow) {
        double value = dataRow.getTargetValue();
        double count = dataRow.getTargetStatistic(StatisticsMap.StatisticName.ROW_COUNT);
        this.totalRecordCount += (int)count;
        this.weightedTotal += count * value;
        if (this.totalRecordCount > 0) {
            this.weightedMean = this.weightedTotal / (double)this.totalRecordCount;
        }
        this.mean = this.weightedMean;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.totalRecordCount).append(this.weightedMean).append(this.weightedTotal).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WeightedMeanAnnotation)) {
            return false;
        }
        WeightedMeanAnnotation other = (WeightedMeanAnnotation)obj;
        return new EqualsBuilder().append(this.totalRecordCount, other.totalRecordCount).append(this.weightedMean, other.weightedMean).append(this.weightedTotal, other.weightedTotal).isEquals();
    }
}

