/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.impl.math;

import com.ibm.bi.predict.math.NumberFormatter;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.sa.execution.annotation.impl.types.FitLineType;
import com.ibm.bi.predict.sa.execution.annotation.impl.types.LineEquation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EquationBuilder {
    private EquationBuilder() {
    }

    public static LineEquation buildEquation(String responseName, String explanatoryName, double[] coefficients, int degree) {
        ArrayList<Double> finalCoefficients = new ArrayList<Double>();
        if (EquationBuilder.zeroCoefficients(coefficients)) {
            return new LineEquation(FitLineType.NONE, locale -> "");
        }
        String escapedResponseName = EquationBuilder.escapeSpecialChars(responseName);
        String escapedExplanatoryName = EquationBuilder.escapeSpecialChars(explanatoryName);
        StringBuilder equation = new StringBuilder();
        equation.append(escapedResponseName);
        equation.append(" = ");
        boolean previousCoeffNonZero = false;
        for (int deg = 0; deg < coefficients.length; ++deg) {
            double coefficient = coefficients[deg];
            if (coefficient == 0.0) continue;
            if (deg == 0) {
                equation.append("%s");
                finalCoefficients.add(coefficient);
                previousCoeffNonZero = true;
                continue;
            }
            if (previousCoeffNonZero) {
                String sign = coefficient < 0.0 ? " - " : " + ";
                equation.append(sign);
            } else {
                previousCoeffNonZero = true;
            }
            finalCoefficients.add(Math.abs(coefficient));
            equation.append("%s");
            equation.append(" * ");
            equation.append(escapedExplanatoryName);
            if (deg <= 1) continue;
            equation.append("^" + deg);
        }
        return new LineEquation(EquationBuilder.findFitLineType(coefficients), locale -> EquationBuilder.formatEquation(locale, equation.toString(), finalCoefficients));
    }

    private static String formatEquation(Locale locale, String equation, List<Double> coefficients) {
        Object[] formattedCoefficients = coefficients.stream().map(c -> NumberFormatter.format((Locale)locale, (boolean)false, (double)c)).collect(Collectors.toList()).toArray(new String[coefficients.size()]);
        return String.format(equation, formattedCoefficients);
    }

    private static FitLineType findFitLineType(double[] coefficients) {
        if (coefficients.length > 2) {
            return FitLineType.QUADRATIC;
        }
        if (coefficients.length == 2 && coefficients[1] < 0.0) {
            return FitLineType.NEGATIVE_LINEAR;
        }
        if (coefficients.length == 2 && coefficients[1] >= 0.0) {
            return FitLineType.POSITIVE_LINEAR;
        }
        return FitLineType.NONE;
    }

    private static boolean zeroCoefficients(double[] coefficients) {
        return Arrays.stream(coefficients).allMatch(NumericUtils::isZero);
    }

    private static String escapeSpecialChars(String text) {
        return StringUtils.replace((String)text, (String)"%", (String)"%%");
    }
}

