/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.impl.math;

import com.ibm.bi.predict.data.matrix.Matrix;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;

public class StatisticsMap {
    private final Map<StatisticName, Matrix> statistics = new EnumMap<StatisticName, Matrix>(StatisticName.class);

    public static StatisticsMap empty() {
        return new StatisticsMap();
    }

    public Optional<Matrix> getStatistic(StatisticName statName) {
        return Optional.ofNullable(this.statistics.get((Object)statName));
    }

    public void addStatistic(StatisticName statName, Matrix statistic) {
        this.statistics.put(statName, statistic);
    }

    public void updateStatistic(StatisticName statName, int row, int col, double value) {
        this.getStatistic(statName).ifPresent(s -> s.setValue(row, col, value));
    }

    public int size() {
        return this.statistics.size();
    }

    public static enum StatisticName {
        ROW_COUNT("rowCount"),
        SUM_OF_SQUARES("sumSqr");

        private final String statName;

        private StatisticName(String statName) {
            this.statName = statName;
        }

        public String toString() {
            return this.statName;
        }
    }
}

