/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.response;

import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.sa.execution.annotation.response.FailedAnnotationResponse;
import com.ibm.bi.predict.sa.execution.annotation.response.Message;
import com.ibm.bi.predict.sa.execution.annotation.response.Title;
import com.ibm.bi.predict.sa.execution.annotation.result.ExecutionState;
import com.ibm.bi.predict.sa.execution.api.Diagnostics;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.Caption;
import com.ibm.bi.predict.utils.Tuple;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class Status {
    private ExecutionState state;
    private Set<FailedAnnotationResponse> errors;
    private Set<FailedAnnotationResponse> warnings;
    private List<Message> messages;
    private Title title;
    private Diagnostics diagnostics;
    private boolean reordered;

    private Status(ExecutionState state, Set<FailedAnnotationResponse> errors, Set<FailedAnnotationResponse> warnings, Map<String, List<Caption>> captions, Title title, Diagnostics diagnostics, boolean reordered) {
        this.state = state;
        this.errors = errors;
        this.warnings = warnings;
        this.messages = this.getMessages(captions);
        this.title = title;
        this.diagnostics = diagnostics;
        this.reordered = reordered;
    }

    public static Status buildSuccessStatus(Map<String, List<Caption>> captions, Title title, Diagnostics diagnostics, boolean reordered) {
        return new Status(ExecutionState.SUCCESS, Collections.emptySet(), Collections.emptySet(), captions, title, diagnostics, reordered);
    }

    public static Status buildPartialSuccessStatus(Set<FailedAnnotationResponse> errors, Set<FailedAnnotationResponse> warnings, Map<String, List<Caption>> captions, Title title, Diagnostics diagnostics, boolean reordered) {
        return new Status(ExecutionState.PARTIAL_SUCCESS, errors, warnings, captions, title, diagnostics, reordered);
    }

    public static Status buildFailureStatus(Set<FailedAnnotationResponse> errors, Set<FailedAnnotationResponse> warnings, Map<String, List<Caption>> captions, Title title, Diagnostics diagnostics, boolean reordered) {
        return new Status(ExecutionState.FAILURE, errors, warnings, captions, title, diagnostics, reordered);
    }

    public ExecutionState getState() {
        return this.state;
    }

    public Set<FailedAnnotationResponse> getErrors() {
        return this.errors;
    }

    public Set<FailedAnnotationResponse> getWarnings() {
        return this.warnings;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Title getTitle() {
        return this.title;
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public boolean isReordered() {
        return this.reordered;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject status = new JSONObject();
        status.put("state", (Object)this.state.toString());
        JSONArray errorsArr = new JSONArray();
        this.errors.forEach(error -> errorsArr.add((Object)error.toJson()));
        status.put("errors", (Collection)errorsArr);
        JSONArray warningsArr = new JSONArray();
        this.warnings.forEach(warning -> warningsArr.add((Object)warning.toJson()));
        status.put("warnings", (Collection)warningsArr);
        JSONObject m = new JSONObject();
        this.messages.forEach(message -> {
            try {
                m.put(message.type, (Collection)message.toJson());
            }
            catch (JSONException e) {
                throw new IllegalDataAccessRequest("Attempting to put bad values to JSONObject", (Throwable)e);
            }
        });
        status.put("messages", (Map)m);
        status.put("title", (Map)this.title.toJson());
        status.put("diagnostics", (Collection)this.diagnostics.getJsonArray());
        status.put("reordered", this.reordered);
        return status;
    }

    private List<Message> getMessages(Map<String, List<Caption>> captions) {
        return captions.entrySet().stream().map(annTypeWithCaptions -> new Message((String)annTypeWithCaptions.getKey(), Status.captionsListToMessageTuple((List)annTypeWithCaptions.getValue()))).collect(Collectors.toList());
    }

    private static List<Tuple<String, String>> captionsListToMessageTuple(List<Caption> captions) {
        return captions.stream().map(caption -> Tuple.of((Object)caption.shortMessage, (Object)caption.longMessage)).collect(Collectors.toList());
    }
}

