/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.result;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.api.Diagnostics;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ExecutionResult {
    private static final Logger LOG = PredictLoggerFactory.getLogger(ExecutionResult.class);
    public final Map<SuggestedAnnotation, Set<ConditionalResponse>> executionIssues;
    public final ListMultimap<SuggestedAnnotation, AnnotationResult<?>> results;
    public final JSONObject originalRequest;
    private final Diagnostics diagnostics;
    public final boolean reordered;

    public ExecutionResult(Map<SuggestedAnnotation, Set<ConditionalResponse>> executionIssues, ListMultimap<SuggestedAnnotation, AnnotationResult<?>> results, JSONObject originalRequest, Diagnostics diagnostics, boolean reordered) {
        this.executionIssues = executionIssues;
        this.results = results;
        this.originalRequest = originalRequest;
        this.diagnostics = diagnostics;
        this.reordered = reordered;
    }

    public static ExecutionResult failure(Map<SuggestedAnnotation, Set<ConditionalResponse>> failures, JSONObject originalRequest, Diagnostics diagnostics) {
        return new ExecutionResult(failures, (ListMultimap<SuggestedAnnotation, AnnotationResult<?>>)ArrayListMultimap.create(), originalRequest, diagnostics, false);
    }

    public Map<SuggestedAnnotation, Set<ConditionalResponse>> getExecutionIssues() {
        return this.executionIssues;
    }

    public ListMultimap<SuggestedAnnotation, AnnotationResult<?>> getResults() {
        return this.results;
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.executionIssues).append(this.results).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExecutionResult)) {
            return false;
        }
        ExecutionResult other = (ExecutionResult)obj;
        return new EqualsBuilder().append(this.executionIssues, other.executionIssues).append(this.results, other.results).isEquals();
    }

    public JSONObject getPredictResults() {
        JSONObject predictResults = new JSONObject();
        JSONArray statDetailsArray = new JSONArray();
        this.results.entries().stream().filter(tsr -> !((AnnotationResult)tsr.getValue()).getStatisticalDetails().isEmpty()).forEach(tsr -> ((AnnotationResult)tsr.getValue()).getStatisticalDetails().forEach(statDetails -> statDetailsArray.add(statDetails.get())));
        if (!statDetailsArray.isEmpty()) {
            try {
                predictResults.put("statisticalDetails", (Collection)statDetailsArray);
            }
            catch (JSONException e) {
                LOG.error("JSONException when appending statisticalDetails to predict result object error={}", (Object)e.getMessage(), (Object)e);
            }
        }
        return predictResults;
    }

    public boolean isReordered() {
        return this.reordered;
    }
}

