/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.annotation.result;

import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.sa.execution.annotation.impl.types.CategoryName;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class MeaningfulDifferencesResult
implements AnnotationResult<List<MeaningfulDifferencesData>> {
    private List<MeaningfulDifferencesData> result;

    public MeaningfulDifferencesResult(List<MeaningfulDifferencesData> result) {
        this.result = result;
    }

    @Override
    public List<MeaningfulDifferencesData> getResult() {
        return this.result;
    }

    public static class MeaningfulDifferencesData
    implements Comparable<MeaningfulDifferencesData> {
        private int cellIdx;
        private String outlierType;
        private double expectedValue;
        private double outlierMeasureValue;
        private List<CategoryName> categoryNames;
        private String responseName;
        private List<String> explanatoryNames;
        private Optional<AggregationType> aggregationType;

        public MeaningfulDifferencesData(int cellIdx, String outlierType, double expectedValue, double outlierMeasureValue, CategoryName categoryName, String responseName, List<String> explanatoryNames) {
            this(cellIdx, outlierType, expectedValue, outlierMeasureValue, Arrays.asList(categoryName), responseName, explanatoryNames, Optional.empty());
        }

        public MeaningfulDifferencesData(int cellIdx, String outlierType, double expectedValue, double outlierMeasureValue, List<CategoryName> categoryName, String responseName, List<String> explanatoryNames) {
            this(cellIdx, outlierType, expectedValue, outlierMeasureValue, categoryName, responseName, explanatoryNames, Optional.empty());
        }

        public MeaningfulDifferencesData(int cellIdx, String outlierType, double expectedValue, double outlierMeasureValue, CategoryName categoryName, String responseName, List<String> explanatoryNames, Optional<AggregationType> aggregationType) {
            this(cellIdx, outlierType, expectedValue, outlierMeasureValue, Arrays.asList(categoryName), responseName, explanatoryNames, aggregationType);
        }

        public MeaningfulDifferencesData(int cellIdx, String outlierType, double expectedValue, double outlierMeasureValue, List<CategoryName> categoryNames, String responseName, List<String> explanatoryNames, Optional<AggregationType> aggregationType) {
            this.cellIdx = cellIdx;
            this.outlierType = outlierType;
            this.expectedValue = expectedValue;
            this.outlierMeasureValue = outlierMeasureValue;
            this.categoryNames = categoryNames;
            this.responseName = responseName;
            this.explanatoryNames = explanatoryNames;
            this.aggregationType = aggregationType;
        }

        public int getCellIndex() {
            return this.cellIdx;
        }

        public String getOutlierTypeValue() {
            return this.outlierType;
        }

        public double getOutlierExpectedValue() {
            return this.expectedValue;
        }

        public double getOutlierMeasureValue() {
            return this.outlierMeasureValue;
        }

        public List<CategoryName> getCategoryNames() {
            return this.categoryNames;
        }

        public String getResponseName() {
            return this.responseName;
        }

        public List<String> getExplanatoryNames() {
            return this.explanatoryNames;
        }

        public Optional<AggregationType> getAggregationType() {
            return this.aggregationType;
        }

        @Override
        public int compareTo(MeaningfulDifferencesData data) {
            return Double.compare(this.getOutlierMeasureValue(), data.getOutlierMeasureValue());
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.cellIdx).append((Object)this.outlierType).append(this.expectedValue).append(this.outlierMeasureValue).append(this.categoryNames).append((Object)this.responseName).append(this.explanatoryNames).append(this.aggregationType).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MeaningfulDifferencesData)) {
                return false;
            }
            MeaningfulDifferencesData other = (MeaningfulDifferencesData)MeaningfulDifferencesData.class.cast(obj);
            return new EqualsBuilder().append(this.cellIdx, other.cellIdx).append((Object)this.outlierType, (Object)other.outlierType).append(this.expectedValue, other.expectedValue).append(this.outlierMeasureValue, other.outlierMeasureValue).append(this.categoryNames, other.categoryNames).append((Object)this.responseName, (Object)other.responseName).append(this.explanatoryNames, other.explanatoryNames).append(this.aggregationType, other.aggregationType).isEquals();
        }

        public String toString() {
            return String.format("[cellIdx: %d, outlierType: %s, expectedValue: %f, measureValue: %f, categoryName: %s, responseName: %s, explanatoryName: %s, aggregationType: %s ]", this.cellIdx, this.outlierType, this.expectedValue, this.outlierMeasureValue, this.categoryNames, this.responseName, this.explanatoryNames, this.aggregationType);
        }
    }
}

