/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api;

import com.ibm.bi.predict.utils.Tuple;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class Diagnostics {
    private static final String TYPE_KEY = "type";
    private long overall;
    private Map<String, List<Tuple<String, Double>>> inputConcepts;

    public Diagnostics(long overall, Map<String, List<Tuple<String, Double>>> inputConcepts) {
        this.overall = overall;
        this.inputConcepts = inputConcepts;
    }

    public long getOverall() {
        return this.overall;
    }

    public Map<String, List<Tuple<String, Double>>> getInputConcepts() {
        return this.inputConcepts;
    }

    public JSONArray getJsonArray() throws JSONException {
        JSONArray diagnosticsArray = new JSONArray();
        JSONObject timingObject = this.createTimingObject();
        JSONObject inputConceptsObject = this.createInputConceptsObject();
        diagnosticsArray.add((Object)timingObject);
        diagnosticsArray.add((Object)inputConceptsObject);
        return diagnosticsArray;
    }

    private JSONObject createTimingObject() throws JSONException {
        JSONObject timingObject = new JSONObject();
        timingObject.put(TYPE_KEY, (Object)"timing");
        timingObject.put("overall", this.overall);
        return timingObject;
    }

    private JSONObject createInputConceptsObject() throws JSONException {
        JSONObject inputConceptsObject = new JSONObject();
        JSONObject inputConceptsPerField = new JSONObject();
        for (Map.Entry<String, List<Tuple<String, Double>>> entry : this.inputConcepts.entrySet()) {
            JSONObject fieldObject = new JSONObject();
            JSONArray conceptsArray = new JSONArray();
            conceptsArray.addAll((Collection)entry.getValue().stream().map(value -> {
                String[] conceptParts = ((String)value._1).split("#");
                return conceptParts[conceptParts.length - 1];
            }).collect(Collectors.toList()));
            fieldObject.put("ids", (Collection)conceptsArray);
            JSONArray confidenceValues = new JSONArray();
            confidenceValues.addAll((Collection)entry.getValue().stream().map(value -> (Double)value._2).collect(Collectors.toList()));
            fieldObject.put("confidenceValues", (Collection)confidenceValues);
            inputConceptsPerField.put(entry.getKey(), (Map)fieldObject);
        }
        inputConceptsObject.put("inputConcepts", (Map)inputConceptsPerField);
        inputConceptsObject.put(TYPE_KEY, (Object)"concepts");
        return inputConceptsObject;
    }
}

