/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api;

import com.google.common.collect.Sets;
import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.json.JsonConceptParser;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.sa.execution.api.DataAccessProviderFactory;
import com.ibm.bi.predict.sa.execution.api.ExecutionContext;
import com.ibm.bi.predict.sa.execution.api.ExecutionRequestValidator;
import com.ibm.bi.predict.sa.execution.api.JsonInputData;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.service.DataProvider;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ExecutionRequestMapper {
    private static final Logger log = PredictLoggerFactory.getLogger(ExecutionRequestMapper.class);
    static final String DATA_KEY = "data";
    static final String DATASET_KEY = "dataset";
    static final String DATASETID_KEY = "datasetId";
    static final String DATAITEMS_KEY = "dataItems";
    static final String PARAMS_KEY = "params";
    static final String ANNOTATIONS_KEY = "annotations";
    private final DataAccessProviderFactory<JSONObject> dataProviderFactory;

    public ExecutionRequestMapper(DataAccessProviderFactory<JSONObject> dataProviderFactory) {
        this.dataProviderFactory = dataProviderFactory;
    }

    public List<PredictServiceRequest> mapJsonToRequests(JSONObject input, Locale locale, Map<String, Object> extraInfo) {
        log.debug("Mapping JSON input to execution requests");
        ExecutionRequestValidator validator = new ExecutionRequestValidator();
        validator.validate(input);
        log.perfStart();
        Map datasetConceptsMap = JsonConceptParser.parseConcepts((JSONObject)input);
        List<PredictServiceRequest> result = input.containsKey((Object)DATA_KEY) ? Collections.singletonList(this.getRequestForSingleDataSets(input, datasetConceptsMap, locale, extraInfo)) : this.getRequestsForMultipleDataSets(input, datasetConceptsMap, locale, extraInfo);
        log.perfStop("Completed mapping of JSON input to execution requests - numRequests=" + result.size());
        return result;
    }

    private List<PredictServiceRequest> getRequestsForMultipleDataSets(JSONObject input, Map<String, Map<String, List<Tuple<String, Double>>>> datasetConceptsMap, Locale locale, Map<String, Object> extraInfo) {
        JSONArray dataSets = ExecutionRequestMapper.getArray(input, DATASET_KEY);
        ArrayList<PredictServiceRequest> requests = new ArrayList<PredictServiceRequest>();
        for (int i = 0; i < dataSets.size(); ++i) {
            JSONObject dataSet = ExecutionRequestMapper.getObject(dataSets, i);
            String dataSetId = ExecutionRequestMapper.getString(dataSet, DATASETID_KEY);
            Map<String, List<Tuple<String, Double>>> conceptsMap = datasetConceptsMap.getOrDefault(dataSetId, Collections.emptyMap());
            DataAccessProvider dataAccessProvider = this.getDataAccessProvider(dataSet, conceptsMap);
            requests.add(new PredictServiceRequest(this.dataProvider(dataAccessProvider), (Context)this.getSuggestionsForDataSet(input, dataSetId, dataAccessProvider.getMetaData()), locale, extraInfo));
        }
        return requests;
    }

    private PredictServiceRequest getRequestForSingleDataSets(JSONObject input, Map<String, Map<String, List<Tuple<String, Double>>>> datasetConceptsMap, Locale locale, Map<String, Object> extraInfo) {
        JSONObject dataSet = ExecutionRequestMapper.getObject(input, DATA_KEY);
        String dataSetId = dataSet.optString(DATASETID_KEY, "");
        Map<String, List<Tuple<String, Double>>> conceptsMap = datasetConceptsMap.getOrDefault(dataSetId, Collections.emptyMap());
        DataAccessProvider dataAccessProvider = this.getDataAccessProvider(dataSet, conceptsMap);
        return new PredictServiceRequest(this.dataProvider(dataAccessProvider), (Context)this.getSuggestions(input, dataAccessProvider.getMetaData()), locale, extraInfo);
    }

    private DataAccessProvider getDataAccessProvider(JSONObject dataSet, Map<String, List<Tuple<String, Double>>> conceptsMap) {
        return this.dataProviderFactory.make(new JsonInputData(dataSet), conceptsMap);
    }

    private ExecutionContext getSuggestionsForDataSet(JSONObject input, String dataSetId, MetaData metadata) {
        JSONArray suggestionsInput = ExecutionRequestMapper.getSuggestionsJson(input);
        HashSet suggestions = Sets.newHashSet();
        for (int i = 0; i < suggestionsInput.size(); ++i) {
            JSONObject suggestion = ExecutionRequestMapper.getObject(suggestionsInput, i);
            String suggestionDataSetId = ExecutionRequestMapper.getString(suggestion, DATASETID_KEY);
            if (!dataSetId.equals(suggestionDataSetId)) continue;
            suggestions.add(ExecutionRequestMapper.newSuggestion(suggestion, metadata));
        }
        ExecutionContext context = new ExecutionContext();
        context.setSuggestedAnnotations(suggestions);
        context.setOriginalRequest(input);
        return context;
    }

    private ExecutionContext getSuggestions(JSONObject input, MetaData metadata) {
        JSONArray suggestionsInput = ExecutionRequestMapper.getSuggestionsJson(input);
        HashSet suggestions = Sets.newHashSet();
        for (int i = 0; i < suggestionsInput.size(); ++i) {
            JSONObject suggestion = ExecutionRequestMapper.getObject(suggestionsInput, i);
            suggestions.add(ExecutionRequestMapper.newSuggestion(suggestion, metadata));
        }
        ExecutionContext context = new ExecutionContext();
        context.setSuggestedAnnotations(suggestions);
        context.setOriginalRequest(input);
        return context;
    }

    private Supplier<DataProvider> dataProvider(DataAccessProvider dataAccessProvider) {
        return () -> DataProvider.fromDataAccessProvider((DataAccessProvider)dataAccessProvider);
    }

    private static SuggestedAnnotation newSuggestion(JSONObject suggestion, MetaData metadata) {
        try {
            return SuggestedAnnotation.fromJson(suggestion, metadata);
        }
        catch (JSONException e) {
            throw new PredictException("Unexpected JSONException while creating suggested annotation", (Throwable)e);
        }
    }

    private static JSONArray getSuggestionsJson(JSONObject input) {
        return ExecutionRequestMapper.getArray(ExecutionRequestMapper.getObject(input, PARAMS_KEY), ANNOTATIONS_KEY);
    }

    private static JSONObject getObject(JSONObject o, String key) {
        try {
            return o.getJSONObject(key);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Could not find object key in input - key=" + key, e);
        }
    }

    private static JSONObject getObject(JSONArray a, int index) {
        try {
            return a.getJSONObject(index);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Could not find object index in input - index=" + index, e);
        }
    }

    private static String getString(JSONObject o, String key) {
        try {
            return o.getString(key);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Could not find key in input - key=" + key, e);
        }
    }

    private static JSONArray getArray(JSONObject o, String key) {
        try {
            return o.getJSONArray(key);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Could not find array key in input - key=" + key, e);
        }
    }
}

