/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api;

import com.ibm.bi.predict.exceptions.BadParametersException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ExecutionRequestValidator {
    final List<String> errors = new ArrayList<String>();

    public void validate(JSONObject request) {
        this.errors.clear();
        try {
            this.validateParams(request);
            boolean hasData = false;
            if (request.containsKey((Object)"data")) {
                hasData = true;
                this.validateData(request);
            }
            if (request.containsKey((Object)"dataset")) {
                hasData = true;
                this.validateDataset(request);
            }
            if (!hasData) {
                this.errors.add("Request must have 'data' or 'dataset'");
            }
        }
        catch (Exception e) {
            this.errors.add("Unexpected exception " + e.getMessage());
        }
        if (!this.errors.isEmpty()) {
            String msg = Objects.toString(this.errors);
            msg = msg.substring(1, msg.length() - 1);
            throw new BadParametersException("Validation errors: " + msg);
        }
    }

    private void validateParams(JSONObject request) throws JSONException {
        JSONObject params = this.getObject("", request, "params");
        if (params != null) {
            this.getArray("params.", params, "annotations");
        }
    }

    private void validateData(JSONObject request) throws JSONException {
        JSONObject data = this.getObject("", request, "data");
        if (data != null) {
            this.validateDataObject("data.", data, false);
        }
    }

    private void validateDataset(JSONObject request) throws JSONException {
        JSONArray array = this.getArray("", request, "dataset");
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                this.validateDataObject("dataset[" + i + "].", array.getJSONObject(i), true);
            }
        }
    }

    private void validateDataObject(String hint, JSONObject obj, boolean checkDatasetId) throws JSONException {
        this.getArray(hint, obj, "data");
        this.getArray(hint, obj, "dataItems");
        if (checkDatasetId) {
            if (!obj.containsKey((Object)"datasetId")) {
                this.errors.add(hint + "datasetId missing");
            } else {
                Object o = obj.get("datasetId");
                if (!(o instanceof String)) {
                    this.errors.add(hint + "datasetId not string");
                }
            }
        }
    }

    private JSONObject getObject(String hint, JSONObject obj, String key) throws JSONException {
        if (!obj.containsKey((Object)key)) {
            this.errors.add(hint + key + " missing");
            return null;
        }
        Object o = obj.get(key);
        if (!(o instanceof JSONObject)) {
            this.errors.add(hint + key + " not object");
            return null;
        }
        return (JSONObject)o;
    }

    private JSONArray getArray(String hint, JSONObject obj, String key) throws JSONException {
        if (!obj.containsKey((Object)key)) {
            this.errors.add(hint + key + " missing");
            return null;
        }
        Object o = obj.get(key);
        if (!(o instanceof JSONArray)) {
            this.errors.add(hint + key + " not array");
            return null;
        }
        JSONArray array = (JSONArray)o;
        boolean allValid = true;
        for (int i = 0; i < array.size(); ++i) {
            o = array.get(i);
            if (o instanceof JSONObject) continue;
            this.errors.add(hint + key + "[" + i + "] not an object");
            allValid = false;
        }
        return allValid ? array : null;
    }
}

