/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api;

import com.ibm.bi.predict.sa.execution.annotation.response.FailedAnnotationResponse;
import com.ibm.bi.predict.sa.execution.annotation.response.Status;
import com.ibm.bi.predict.sa.execution.annotation.response.Title;
import com.ibm.bi.predict.sa.execution.api.Diagnostics;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.Caption;
import com.ibm.bi.predict.service.PredictServiceResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ExecutionResponse
implements PredictServiceResponse {
    protected static final String DATASET_KEY = "dataset";
    protected static final String DATA_KEY = "data";
    protected static final String PREDICT_STATUS_KEY = "predictStatus";
    protected static final String PREDICT_RESULTS_KEY = "predictResults";
    private final PredictServiceResponse.HttpStatusCode statusCode;
    private final Status predictStatus;
    private final JSONObject predictResults;
    private final JSONObject originalRequest;

    public ExecutionResponse(PredictServiceResponse.HttpStatusCode statusCode, Status predictStatus, JSONObject predictResults, JSONObject originalRequest) {
        this.statusCode = statusCode;
        this.predictStatus = predictStatus;
        this.predictResults = predictResults;
        this.originalRequest = originalRequest;
    }

    public PredictServiceResponse.HttpStatusCode getResponseCode() {
        return this.statusCode;
    }

    public JSONObject getResponseBody() throws JSONException {
        JSONObject response = this.originalRequest.containsKey((Object)DATA_KEY) ? this.originalRequest.getJSONObject(DATA_KEY) : new JSONObject();
        if (this.originalRequest.containsKey((Object)DATASET_KEY)) {
            response.put(DATASET_KEY, this.originalRequest.get(DATASET_KEY));
        }
        if (!this.predictResults.isEmpty()) {
            response.put(PREDICT_RESULTS_KEY, (Map)this.predictResults);
        }
        response.put(PREDICT_STATUS_KEY, (Map)this.predictStatus.toJson());
        return response;
    }

    public Status getStatus() {
        return this.predictStatus;
    }

    public JSONObject getPredictResults() {
        return this.predictResults;
    }

    public static ExecutionResponse getSuccessfulResponse(Map<String, List<Caption>> captions, Title title, JSONObject predictResponse, JSONObject originalRequest, Diagnostics diagnostics, boolean reordered) {
        return new ExecutionResponse(PredictServiceResponse.HttpStatusCode.SUCCESS, Status.buildSuccessStatus(captions, title, diagnostics, reordered), predictResponse, originalRequest);
    }

    public static ExecutionResponse getFailureResponse(Map<String, List<Caption>> captions, Set<FailedAnnotationResponse> warnings, Set<FailedAnnotationResponse> errors, Title title, JSONObject predictResponse, JSONObject originalRequest, Diagnostics diagnostics, boolean reordered) {
        return new ExecutionResponse(PredictServiceResponse.HttpStatusCode.ERROR, Status.buildFailureStatus(errors, warnings, captions, title, diagnostics, reordered), predictResponse, originalRequest);
    }

    public static ExecutionResponse getPartialSuccessResponse(Map<String, List<Caption>> captions, Set<FailedAnnotationResponse> warnings, Set<FailedAnnotationResponse> errors, Title title, JSONObject predictResponse, JSONObject originalRequest, Diagnostics diagnostics, boolean reordered) {
        return new ExecutionResponse(PredictServiceResponse.HttpStatusCode.SUCCESS, Status.buildPartialSuccessStatus(errors, warnings, captions, title, diagnostics, reordered), predictResponse, originalRequest);
    }
}

