/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api;

import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.sa.execution.annotation.FieldRole;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MetaDataAdapter {
    private MetaData metadata;
    private SuggestedAnnotation annotationSuggestion;

    public MetaDataAdapter(MetaData metadata, SuggestedAnnotation annotationSuggestion) {
        this.metadata = metadata;
        this.annotationSuggestion = annotationSuggestion;
    }

    public String getResponseName() {
        return this.getNameOfField(this.annotationSuggestion.indexOfTarget);
    }

    public String getNameOfFirstExplanatoryField() {
        return this.getNameOfExplanatoryField(0);
    }

    public String getNameOfExplanatoryField(int explanatoryIndex) {
        return this.getNameOfField(this.annotationSuggestion.indexesOfExplanatoryFields.get(explanatoryIndex));
    }

    public String getNameOfField(int fieldIndex) {
        return this.metadata.getFieldDisplayLabel(fieldIndex);
    }

    public List<String> getNamesOfField(int fieldIndex) {
        return this.metadata.getFieldDisplayLabels(fieldIndex);
    }

    public String getCategoryNameOfExplanatoryField(int explanatoryFieldIndex, int categoryIndex) {
        return this.metadata.getFieldCategoryLabel(this.annotationSuggestion.indexesOfExplanatoryFields.get(explanatoryFieldIndex).intValue(), categoryIndex);
    }

    public int getCountOfResponseFieldCategories() {
        return this.getCountOfFieldCategories(this.annotationSuggestion.indexOfTarget);
    }

    public int getCountOfFirstExplanatoryFieldCategories() {
        return this.getCountOfExplanatoryFieldCategories(0);
    }

    public int getCountOfExplanatoryFieldCategories(int explanatoryFieldIndex) {
        return this.getCountOfFieldCategories(this.annotationSuggestion.indexesOfExplanatoryFields.get(explanatoryFieldIndex));
    }

    public int getCountOfFieldCategories(int fieldIdx) {
        return this.metadata.getFieldCategories(fieldIdx);
    }

    public Optional<Integer> getCountOfCategoriesByRole(FieldRole role) {
        Optional<Integer> fieldIndex = this.getIndexByRole(role);
        return fieldIndex.map(index -> this.metadata.getFieldCategories(((Integer)fieldIndex.get()).intValue()));
    }

    public int getNumberOfFields() {
        return this.metadata.fieldCount();
    }

    public int getNumberOfExplanatoryFields() {
        return this.annotationSuggestion.indexesOfExplanatoryFields.size();
    }

    public Optional<AggregationType> getAggregationTypeOfField(int fieldIndex) {
        AggregationType type = this.metadata.getFieldAggregation(fieldIndex);
        if (type == AggregationType.NONE || type == null) {
            return Optional.empty();
        }
        return Optional.of(type);
    }

    public List<Optional<AggregationType>> getCategoryAggregationsForField(int fieldIndex, int categoryIndex) {
        List aggs = this.metadata.getFieldCategoryAggregations(fieldIndex, categoryIndex);
        return aggs.stream().map(agg -> agg == AggregationType.NONE ? Optional.empty() : Optional.ofNullable(agg)).collect(Collectors.toList());
    }

    public String getCategoryNameForField(int fieldIndex, int categoryIndex) {
        return this.metadata.getFieldCategoryLabel(fieldIndex, categoryIndex);
    }

    public List<String> getCategoryNamesForField(int fieldIndex, int categoryIndex) {
        return this.metadata.getFieldCategoryLabels(fieldIndex, categoryIndex);
    }

    public String getCategoryIdentifierForField(int fieldIndex, int categoryIndex) {
        return this.metadata.getFieldCategoryIdentifier(fieldIndex, categoryIndex);
    }

    public Optional<Integer> getIndexByRole(FieldRole role) {
        int index = this.annotationSuggestion.roles.indexOf(role.toString());
        if (index < 0) {
            return Optional.empty();
        }
        String id = this.annotationSuggestion.dataItems.get(index);
        for (int i = 0; i < this.metadata.fieldCount(); ++i) {
            if (!id.equals(this.metadata.getFieldIdentifier(i))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public Map<String, Object> getModelOptions() {
        return this.annotationSuggestion.modelOptions;
    }

    public List<Integer> getFieldIndicesByRole(FieldRole role) {
        List dataItemsWithRole = IntStream.range(0, this.annotationSuggestion.roles.size()).filter(idx -> FieldRole.fromString(this.annotationSuggestion.roles.get(idx)) == role).mapToObj(this.annotationSuggestion.dataItems::get).collect(Collectors.toList());
        ArrayList<Integer> indices = new ArrayList<Integer>();
        block0: for (String dataItemId : dataItemsWithRole) {
            for (int i = 0; i < this.metadata.fieldCount(); ++i) {
                String id = this.metadata.getFieldIdentifier(i);
                if (!dataItemId.equals(id)) continue;
                indices.add(i);
                continue block0;
            }
        }
        return indices;
    }

    public Optional<Integer> getExplanatoryFieldIndexByType(FieldType type) {
        for (int i = 0; i < this.annotationSuggestion.indexesOfExplanatoryFields.size(); ++i) {
            int explanatoryIndex = this.annotationSuggestion.indexesOfExplanatoryFields.get(i);
            if (this.metadata.getFieldType(explanatoryIndex) != type) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public List<Integer> getExplanatoryFieldIndices() {
        return this.annotationSuggestion.indexesOfExplanatoryFields;
    }

    public int getResponseIndex() {
        return this.annotationSuggestion.indexOfTarget;
    }

    public FieldType getFieldType(int fieldIdx) {
        return this.metadata.getFieldType(fieldIdx);
    }

    public int rowCount() {
        return this.metadata.rowCount();
    }

    public int factorACount() {
        return this.isTwoWay() ? this.getCountOfExplanatoryFieldCategories(0) : 1;
    }

    public int factorBCount() {
        return this.isTwoWay() ? this.getCountOfExplanatoryFieldCategories(1) : this.getCountOfExplanatoryFieldCategories(0);
    }

    public boolean isTwoWay() {
        return this.getNumberOfExplanatoryFields() == 2;
    }

    public int fieldCount() {
        return this.metadata.fieldCount();
    }

    public String getFieldId(int fieldIndex) {
        return this.metadata.getFieldIdentifier(fieldIndex);
    }

    public List<String> getFieldIds(int fieldIndex) {
        return this.metadata.getFieldIdentifiers(fieldIndex);
    }

    public String getFieldId(int fieldIndex, int subFieldIndex) {
        return (String)this.metadata.getFieldIdentifiers(fieldIndex).get(subFieldIndex);
    }

    public boolean multipleFieldsInResponse() {
        return "values".equals(this.getFieldId(this.getResponseIndex()));
    }

    public boolean isStackedField(int fieldIndex) {
        return this.stackedCount(fieldIndex) > 1;
    }

    public int stackedCount(int fieldIndex) {
        return this.metadata.itemsInField(fieldIndex);
    }

    public int multipleMeasuresIndex() {
        if (this.multipleFieldsInResponse()) {
            Optional<Integer> groupField = this.getIndexByRole(FieldRole.GROUP);
            return groupField.map(groupIndex -> {
                int multipleMeasuresIndex = IntStream.range(0, this.stackedCount((int)groupIndex)).filter(idx -> MetaDataAdapter.isValidMultipleMeasuresGroup(this.getFieldId((int)groupIndex, idx), this.getFieldId((int)groupIndex))).findFirst().orElseThrow(() -> new IllegalDataAccessRequest("Expected to find _multiMeasuresSeries, or group id if no other groups"));
                return multipleMeasuresIndex;
            }).orElseThrow(() -> new IllegalDataAccessRequest("No group index found"));
        }
        return -1;
    }

    private static boolean isValidMultipleMeasuresGroup(String subFieldId, String groupId) {
        return subFieldId.equals("_multiMeasuresSeries") || subFieldId.equals(groupId);
    }
}

