/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api;

import com.google.common.collect.ListMultimap;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.response.Title;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.PredictiveStrengthResult;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TitleGenerator {
    private static final String PREDICTIVE_STRENGTH_TYPE = "PREDICTIVE_STRENGTH";
    private static final String BUNDLE_NAME = "Predict_Smart_Annotations";
    private static final String STRENGTH_TWO_FACTOR_NAME = "PREDICTIVE_STRENGTH_DECO_LONG_TWO_FACTOR";
    private static final String STRENGTH_ONE_FACTOR_NAME = "PREDICTIVE_STRENGTH_DECO_LONG_SINGLE_FACTOR";
    private static final String STRENGTH_TWO_FACTOR_NAME_NO_RELATIONSHIP = "PREDICTIVE_STRENGTH_DECO_LONG_TWO_FACTOR_NO_RELATIONSHIP";
    private static final String STRENGTH_ONE_FACTOR_NAME_NO_RELATIONSHIP = "PREDICTIVE_STRENGTH_DECO_LONG_SINGLE_FACTOR_NO_RELATIONSHIP";
    private static final int MIN_PERCENT_PRECISION = 2;
    private static final int MAX_PERCENT_PRECISION = 4;

    private TitleGenerator() {
    }

    public static Title getTitle(ListMultimap<SuggestedAnnotation, AnnotationResult<?>> results, MessageService messageService, Locale locale) {
        List<PredictiveStrengthResult.PredictiveStrengthData> psResults = TitleGenerator.collectPredictiveStrengthResults(results);
        if (psResults.isEmpty()) {
            return Title.empty();
        }
        List<Title> titleList = TitleGenerator.getTitlesAndTooltips(psResults, messageService, locale);
        if (titleList.size() > 1) {
            return TitleGenerator.consolidateTitleText(titleList);
        }
        return titleList.get(0);
    }

    private static List<PredictiveStrengthResult.PredictiveStrengthData> collectPredictiveStrengthResults(ListMultimap<SuggestedAnnotation, AnnotationResult<?>> results) {
        return results.entries().stream().filter(entry -> PREDICTIVE_STRENGTH_TYPE.equals(((SuggestedAnnotation)entry.getKey()).type)).map(entry -> (PredictiveStrengthResult.PredictiveStrengthData)((AnnotationResult)entry.getValue()).getResult()).collect(Collectors.toList());
    }

    private static List<Title> getTitlesAndTooltips(List<PredictiveStrengthResult.PredictiveStrengthData> psData, MessageService messageService, Locale locale) {
        MessageService.MessageBundle messageBundle = messageService.getMessageBundle(BUNDLE_NAME, locale);
        ArrayList<Title> titles = new ArrayList<Title>();
        psData.forEach(data -> {
            String tooltip;
            String title;
            if (data.hasPredictiveRelationship()) {
                title = TitleGenerator.getTitleForRelationship(data, messageBundle, locale);
                tooltip = TitleGenerator.getTooltipForRelationship(data, messageBundle, locale);
            } else {
                title = TitleGenerator.getTitleForNoRelationship(data, messageBundle, locale);
                tooltip = TitleGenerator.getTooltipForNoRelationship(data, messageBundle, locale);
            }
            titles.add(new Title(title, tooltip));
        });
        return titles;
    }

    private static String getTitleForRelationship(PredictiveStrengthResult.PredictiveStrengthData data, MessageService.MessageBundle messageBundle, Locale locale) {
        List<String> explanatoryFields = data.explanatoryNames;
        String target = data.targetName;
        String strengthPercentage = TitleGenerator.getStrengthAsPercentage(data.strength, locale);
        String strengthName = data.associationStrengthLevel.name();
        if (TitleGenerator.hasMultipleFactors(data)) {
            return TitleGenerator.getText("PREDICTIVE_STRENGTH_DECO_LONG_TWO_FACTOR_" + strengthName, messageBundle, explanatoryFields.get(0), explanatoryFields.get(1), target, strengthPercentage);
        }
        return TitleGenerator.getText("PREDICTIVE_STRENGTH_DECO_LONG_SINGLE_FACTOR_" + strengthName, messageBundle, explanatoryFields.get(0), target, strengthPercentage);
    }

    private static String getTitleForNoRelationship(PredictiveStrengthResult.PredictiveStrengthData data, MessageService.MessageBundle messageBundle, Locale locale) {
        List<String> explanatoryFields = data.explanatoryNames;
        String target = data.targetName;
        if (TitleGenerator.hasMultipleFactors(data)) {
            return TitleGenerator.getText(STRENGTH_TWO_FACTOR_NAME_NO_RELATIONSHIP, messageBundle, explanatoryFields.get(0), explanatoryFields.get(1), target);
        }
        return TitleGenerator.getText(STRENGTH_ONE_FACTOR_NAME_NO_RELATIONSHIP, messageBundle, explanatoryFields.get(0), target);
    }

    private static String getStrengthAsPercentage(double strength, Locale locale) {
        NumberFormat df = NumberFormat.getPercentInstance(locale);
        if (strength < 0.01) {
            df.setMinimumFractionDigits(2);
            df.setMaximumFractionDigits(4);
            df.setRoundingMode(RoundingMode.DOWN);
        }
        return df.format(strength);
    }

    private static String getTooltipForRelationship(PredictiveStrengthResult.PredictiveStrengthData data, MessageService.MessageBundle messageBundle, Locale locale) {
        List<String> explanatoryFields = data.explanatoryNames;
        String target = data.targetName;
        String strengthPercentage = TitleGenerator.getStrengthAsPercentage(data.strength, locale);
        String strengthName = data.associationStrengthLevel.name();
        if (TitleGenerator.hasMultipleFactors(data)) {
            return TitleGenerator.getText("PREDICTIVE_STRENGTH_DECO_LONG_TWO_FACTOR_" + strengthName, messageBundle, explanatoryFields.get(0), explanatoryFields.get(1), target, strengthPercentage);
        }
        return TitleGenerator.getText("PREDICTIVE_STRENGTH_DECO_LONG_SINGLE_FACTOR_" + strengthName, messageBundle, explanatoryFields.get(0), target, strengthPercentage);
    }

    private static String getTooltipForNoRelationship(PredictiveStrengthResult.PredictiveStrengthData data, MessageService.MessageBundle messageBundle, Locale locale) {
        if (TitleGenerator.hasMultipleFactors(data)) {
            return TitleGenerator.getText(STRENGTH_TWO_FACTOR_NAME_NO_RELATIONSHIP, messageBundle, data.explanatoryNames.get(0), data.explanatoryNames.get(1), data.targetName);
        }
        return TitleGenerator.getText(STRENGTH_ONE_FACTOR_NAME_NO_RELATIONSHIP, messageBundle, data.explanatoryNames.get(0), data.targetName);
    }

    private static String getText(String key, MessageService.MessageBundle messageBundle, Object ... params) {
        return messageBundle.getMessage(key, params);
    }

    private static Title consolidateTitleText(List<Title> titles) {
        String consolidatedTitles = TitleGenerator.consolidateList(titles, t -> t.title);
        String consolidatedTooltips = TitleGenerator.consolidateList(titles, t -> t.tooltip);
        return new Title(consolidatedTitles, consolidatedTooltips);
    }

    private static String consolidateList(List<Title> titles, Function<Title, String> f) {
        return titles.stream().map(f::apply).collect(Collectors.joining("; "));
    }

    private static boolean hasMultipleFactors(PredictiveStrengthResult.PredictiveStrengthData data) {
        return data.explanatoryNames.size() > 1;
    }
}

