/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api.messagesgenerator;

import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.MeanResult;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.Caption;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.MessagesGeneratorCommon;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

class AverageMessages {
    private AverageMessages() {
    }

    static List<Caption> getMessagesForAverage(AnnotationResult<?> result, MessageService.MessageBundle messageBundle, Locale locale) {
        if (!(result.getResult() instanceof MeanResult.MeanData)) {
            throw MessagesGeneratorCommon.illegalArgument();
        }
        MeanResult.MeanData meanData = (MeanResult.MeanData)result.getResult();
        double mean = meanData.getMean();
        String responseName = meanData.getResponseName();
        String shortMessage = MessagesGeneratorCommon.getShortMessage(messageBundle, "AVERAGE", mean);
        String longMessage = MessagesGeneratorCommon.getLongMessage(messageBundle, "AVERAGE", responseName, mean);
        longMessage = MessagesGeneratorCommon.formatLongMessage(longMessage, locale);
        return Arrays.asList(new Caption(shortMessage, longMessage));
    }
}

