/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api.messagesgenerator;

import com.google.common.collect.Sets;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.response.FailedAnnotationResponse;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.Caption;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CaptionsForFailures {
    private CaptionsForFailures() {
    }

    public static Map<String, List<Caption>> getCaptionsForFailures(Map<SuggestedAnnotation, Set<ConditionalResponse>> executionIssues, MessageService messageService, Locale locale) {
        MessageService.MessageBundle captionsBundle = messageService.getMessageBundle("Predict_Smart_Annotations", locale);
        HashMap<String, List<Caption>> captions = new HashMap<String, List<Caption>>();
        executionIssues.entrySet().stream().forEach(e -> {
            String annotationType = ((SuggestedAnnotation)e.getKey()).type;
            List<Caption> shortAndLongMessages = CaptionsForFailures.createShortAndLongMessagesForIssues(annotationType, Sets.newHashSet((Iterable)((Iterable)e.getValue())), captionsBundle);
            captions.put(annotationType, shortAndLongMessages);
        });
        return captions;
    }

    private static List<Caption> createShortAndLongMessagesForIssues(String annotationType, Set<ConditionalResponse> issues, MessageService.MessageBundle captionsBundle) {
        return issues.stream().filter(i -> !i.getErrors().isEmpty()).map(i -> {
            FailedAnnotationResponse issue = i.getErrors().get(0);
            String shortMessage = captionsBundle.getMessage(issue.getId(), new Object[0]);
            String longMessage = captionsBundle.getMessage(annotationType + "_" + issue.getId(), issue.getLongMessageParameters());
            return new Caption(shortMessage, longMessage);
        }).collect(Collectors.toList());
    }
}

