/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api.messagesgenerator;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.AverageMessages;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.Caption;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.FitLineMessages;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.MeaningfulDifferencesMessages;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.ModeMessages;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.PredictiveStrengthMessages;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.TimeSeriesMessages;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;

public class CaptionsForResults {
    private CaptionsForResults() {
    }

    public static Map<String, List<Caption>> getCaptionsForResults(ListMultimap<SuggestedAnnotation, AnnotationResult<?>> results, MessageService messageService, Locale locale) {
        MessageService.MessageBundle messageBundle = messageService.getMessageBundle("Predict_Smart_Annotations", locale);
        HashMap<String, List<Caption>> captions = new HashMap<String, List<Caption>>();
        for (Map.Entry entry : results.entries()) {
            String annotationType = ((SuggestedAnnotation)entry.getKey()).type;
            AnnotationResult result = (AnnotationResult)entry.getValue();
            List<Caption> shortAndLongMessages = CaptionsForResults.createShortAndLongMessagesForAnnotationResult(annotationType, result, messageBundle, locale);
            captions.putIfAbsent(annotationType, Lists.newArrayList());
            ((List)captions.get(annotationType)).addAll(shortAndLongMessages);
        }
        return captions;
    }

    private static List<Caption> createShortAndLongMessagesForAnnotationResult(String annotationType, AnnotationResult<?> result, MessageService.MessageBundle messageBundle, Locale locale) {
        List<Caption> results;
        switch (annotationType) {
            case "AVERAGE": {
                results = AverageMessages.getMessagesForAverage(result, messageBundle, locale);
                break;
            }
            case "MEANINGFUL_DIFFERENCES": {
                results = MeaningfulDifferencesMessages.getMessagesForMeaningfulDifferences(result, messageBundle, locale);
                break;
            }
            case "PREDICTIVE_STRENGTH": {
                results = PredictiveStrengthMessages.getMessagesForPredictiveStrength(result, messageBundle, locale);
                break;
            }
            case "FIT_LINE": {
                results = FitLineMessages.getMessagesForFitLine(result, messageBundle, locale);
                break;
            }
            case "MODE": {
                results = ModeMessages.getMessagesForMode(result, messageBundle, locale);
                break;
            }
            case "TIME_SERIES": {
                results = TimeSeriesMessages.getMessagesForTimeSeries(result, messageBundle, locale);
                break;
            }
            default: {
                throw new NotImplementedException(String.format("Unrecognized type: %s encountered while generating menu messages", annotationType));
            }
        }
        return results;
    }
}

