/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api.messagesgenerator;

import com.google.common.collect.Sets;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.response.ConditionalResponse;
import com.ibm.bi.predict.sa.execution.annotation.response.FailedAnnotationResponse;
import com.ibm.bi.predict.utils.Tuple;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ErrorsAndWarnings {
    public static final String BULLET = "\u2022 ";

    private ErrorsAndWarnings() {
    }

    public static Set<FailedAnnotationResponse> getErrors(Set<ConditionalResponse> issues, MessageService messageService, Locale locale) {
        return (Set)ErrorsAndWarnings.getErrorsAndWarnings(issues, (MessageService.MessageBundle)ErrorsAndWarnings.captionsBundle((MessageService)messageService, (Locale)locale))._1;
    }

    public static Set<FailedAnnotationResponse> getWarnings(Set<ConditionalResponse> issues, MessageService messageService, Locale locale) {
        return (Set)ErrorsAndWarnings.getErrorsAndWarnings(issues, (MessageService.MessageBundle)ErrorsAndWarnings.captionsBundle((MessageService)messageService, (Locale)locale))._2;
    }

    private static MessageService.MessageBundle captionsBundle(MessageService messageService, Locale locale) {
        return messageService.getMessageBundle("Predict_Smart_Annotations", locale);
    }

    private static Tuple<Set<FailedAnnotationResponse>, Set<FailedAnnotationResponse>> getErrorsAndWarnings(Set<ConditionalResponse> issues, MessageService.MessageBundle messageBundle) {
        Map<ConditionalResponse.FailureType, Set<FailedAnnotationResponse>> groupedByType = ErrorsAndWarnings.getMessagesGroupedByType(issues, messageBundle);
        Set errors = groupedByType.getOrDefault((Object)ConditionalResponse.FailureType.KEY_ERROR, Collections.emptySet());
        Set warnings = groupedByType.getOrDefault((Object)ConditionalResponse.FailureType.KEY_WARN, Collections.emptySet());
        return Tuple.of((Object)Sets.newHashSet(errors), (Object)Sets.newHashSet(warnings));
    }

    private static Map<ConditionalResponse.FailureType, Set<FailedAnnotationResponse>> getMessagesGroupedByType(Set<ConditionalResponse> messages, MessageService.MessageBundle messageBundle) {
        return messages.stream().flatMap(m -> Sets.newHashSet(m.getErrors()).stream()).map(m -> {
            String caption = BULLET + messageBundle.getMessage(m.getCaption(), m.getErrorMessageParameters());
            return FailedAnnotationResponse.withoutParameters(m.getType(), m.getId(), caption);
        }).collect(Collectors.groupingBy(FailedAnnotationResponse::getType, Collectors.toSet()));
    }
}

