/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.sa.execution.api.messagesgenerator;

import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.math.NumberFormatter;
import com.ibm.bi.predict.sa.execution.annotation.MessageService;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.MeaningfulDifferencesResult;
import com.ibm.bi.predict.sa.execution.annotation.result.OutlierResult;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.Caption;
import com.ibm.bi.predict.sa.execution.api.messagesgenerator.MessagesGeneratorCommon;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class MeaningfulDifferencesMessages {
    private static final int MAX_MEANINGFUL_DIFFS = 5;

    private MeaningfulDifferencesMessages() {
    }

    static List<Caption> getMessagesForMeaningfulDifferences(AnnotationResult<?> result, MessageService.MessageBundle messageBundle, Locale locale) {
        String longMessage;
        if (!result.isEmpty() && !(result.getResult() instanceof List)) {
            throw MessagesGeneratorCommon.illegalArgument();
        }
        if (result.isEmpty()) {
            return Arrays.asList(new Caption(messageBundle.getMessage("MEANINGFUL_DIFFERENCES_SHORT_NO_RESULTS", new Object[0]), messageBundle.getMessage("MEANINGFUL_DIFFERENCES_LONG_NO_RESULTS", new Object[0])));
        }
        int numOfMeaningfulDiff = ((List)result.getResult()).size();
        String shortMessage = MessagesGeneratorCommon.getShortMessage(messageBundle, "MEANINGFUL_DIFFERENCES", numOfMeaningfulDiff);
        if (result instanceof OutlierResult) {
            List outlierData = (List)result.getResult();
            longMessage = MeaningfulDifferencesMessages.getLongMessageForOutliers(outlierData, messageBundle, locale);
        } else if (result instanceof MeaningfulDifferencesResult) {
            List meaningfulDiffData = (List)result.getResult();
            longMessage = MeaningfulDifferencesMessages.getLongMessageForMeaningfulDifferences(meaningfulDiffData, messageBundle);
        } else {
            throw MessagesGeneratorCommon.illegalArgument();
        }
        longMessage = MessagesGeneratorCommon.formatLongMessage(longMessage, locale);
        return Arrays.asList(new Caption(shortMessage, longMessage));
    }

    private static String getLongMessageForOutliers(List<OutlierResult.OutlierData> outlierData, MessageService.MessageBundle messageBundle, Locale locale) {
        Collections.sort(outlierData);
        long numberOfHighOutliers = MeaningfulDifferencesMessages.getOutlierCount(outlierData, outlier -> outlier.outlierMeasureValue >= 0.0);
        long numberOfLowOutliers = MeaningfulDifferencesMessages.getOutlierCount(outlierData, outlier -> outlier.outlierMeasureValue < 0.0);
        Optional<AggregationType> aggregationType = outlierData.get((int)0).responseAggregationType;
        String messageType = MeaningfulDifferencesMessages.getMeaningfulDifferenceLongMessageType(outlierData.size(), numberOfHighOutliers, numberOfLowOutliers, false, aggregationType);
        List<OutlierResult.OutlierData> outliersShown = outlierData.subList(0, Math.min(5, outlierData.size()));
        List<String> outlierCategories = outliersShown.stream().map(d -> String.join((CharSequence)", ", String.valueOf(d.explanatoryValue))).map(val -> MeaningfulDifferencesMessages.formatNumber(val, locale)).collect(Collectors.toList());
        return MeaningfulDifferencesMessages.getLongMessage(messageType, outliersShown.get((int)0).responseName, Arrays.asList(outliersShown.get((int)0).explanatoryName), outlierCategories, messageBundle);
    }

    private static String getMeaningfulDifferenceLongMessageType(long outlierCount, long high, long low, Boolean multipleExp, Optional<AggregationType> aggregationType) {
        String messageType = outlierCount == 1L ? (high == 1L ? "_LONG_ONE_RESPONSE_HIGH" : "_LONG_ONE_RESPONSE_LOW") : (outlierCount == high ? "_LONG_MULTIPLE_RESPONSES_HIGH" : (outlierCount == low ? "_LONG_MULTIPLE_RESPONSES_LOW" : "_LONG_MULTIPLE_RESPONSES_DIFF_SIGN"));
        if (multipleExp.booleanValue()) {
            messageType = messageType + "_MULTI_EXP";
        }
        if (outlierCount > 5L) {
            messageType = messageType + "_MORE";
        }
        if (aggregationType.isPresent() && aggregationType.get() == AggregationType.COUNT) {
            messageType = messageType + "_COUNT";
        }
        return messageType;
    }

    private static String formatNumber(String outlierCategory, Locale locale) {
        return NumberFormatter.format((Locale)locale, (boolean)true, (double)Double.parseDouble(outlierCategory));
    }

    private static String getLongMessageForMeaningfulDifferences(List<MeaningfulDifferencesResult.MeaningfulDifferencesData> meaningfulDiffData, MessageService.MessageBundle messageBundle) {
        Collections.sort(meaningfulDiffData);
        long numberOfHighOutliers = MeaningfulDifferencesMessages.getOutlierCount(meaningfulDiffData, outlier -> "high".equals(outlier.getOutlierTypeValue()));
        long numberOfLowOutliers = MeaningfulDifferencesMessages.getOutlierCount(meaningfulDiffData, outlier -> "low".equals(outlier.getOutlierTypeValue()));
        Optional<AggregationType> aggregationType = meaningfulDiffData.get(0).getAggregationType();
        boolean multipleExp = meaningfulDiffData.get(0).getExplanatoryNames().size() > 1;
        String messageType = MeaningfulDifferencesMessages.getMeaningfulDifferenceLongMessageType(meaningfulDiffData.size(), numberOfHighOutliers, numberOfLowOutliers, multipleExp, aggregationType);
        List<String> outlierCategories = MeaningfulDifferencesMessages.getOutlierCategoriesText(meaningfulDiffData, messageBundle);
        outlierCategories = outlierCategories.subList(0, Math.min(5, meaningfulDiffData.size()));
        return MeaningfulDifferencesMessages.getLongMessage(messageType, meaningfulDiffData.get(0).getResponseName(), meaningfulDiffData.get(0).getExplanatoryNames(), outlierCategories, messageBundle);
    }

    private static List<String> getOutlierCategoriesText(List<MeaningfulDifferencesResult.MeaningfulDifferencesData> sortedMeaningfulDiffData, MessageService.MessageBundle messageBundle) {
        return sortedMeaningfulDiffData.stream().map(d -> {
            List catNames = d.getCategoryNames().stream().map(c -> MessagesGeneratorCommon.getCategoryName(c, messageBundle)).collect(Collectors.toList());
            if (catNames.size() == 1) {
                return (String)catNames.get(0);
            }
            return String.join((CharSequence)" + ", catNames);
        }).collect(Collectors.toList());
    }

    private static String getLongMessage(String messageType, String responseName, List<String> explanatoryNames, List<String> outlierCategories, MessageService.MessageBundle messageBundle) {
        boolean containsMultiple = messageType.contains("MULTIPLE");
        boolean containsOne = messageType.contains("ONE");
        if (containsMultiple && messageType.contains("MULTI_EXP_MORE_COUNT")) {
            return messageBundle.getMessage("MEANINGFUL_DIFFERENCES" + messageType, String.join((CharSequence)", ", outlierCategories), explanatoryNames.get(0), explanatoryNames.get(1));
        }
        if (containsMultiple && messageType.contains("MULTI_EXP_MORE")) {
            return messageBundle.getMessage("MEANINGFUL_DIFFERENCES" + messageType, responseName, explanatoryNames.get(0), explanatoryNames.get(1), String.join((CharSequence)", ", outlierCategories));
        }
        if (containsMultiple && messageType.contains("MULTI_EXP_COUNT")) {
            return messageBundle.getMessage("MEANINGFUL_DIFFERENCES" + messageType, String.join((CharSequence)", ", outlierCategories.subList(0, Math.min(5, outlierCategories.size()) - 1)), outlierCategories.get(Math.min(5, outlierCategories.size()) - 1), explanatoryNames.get(0), explanatoryNames.get(1));
        }
        if (containsMultiple && messageType.contains("MULTI_EXP")) {
            return messageBundle.getMessage("MEANINGFUL_DIFFERENCES" + messageType, responseName, explanatoryNames.get(0), explanatoryNames.get(1), String.join((CharSequence)", ", outlierCategories.subList(0, Math.min(5, outlierCategories.size()) - 1)), outlierCategories.get(Math.min(5, outlierCategories.size()) - 1));
        }
        if (containsOne && messageType.contains("MULTI_EXP_COUNT")) {
            return messageBundle.getMessage("MEANINGFUL_DIFFERENCES" + messageType, outlierCategories.get(0), explanatoryNames.get(0), explanatoryNames.get(1));
        }
        if (containsOne && messageType.contains("MULTI_EXP")) {
            return messageBundle.getMessage("MEANINGFUL_DIFFERENCES" + messageType, responseName, explanatoryNames.get(0), explanatoryNames.get(1), outlierCategories.get(0));
        }
        if (messageType.contains("MORE_COUNT")) {
            return messageBundle.getMessage("MEANINGFUL_DIFFERENCES" + messageType, String.join((CharSequence)", ", outlierCategories), explanatoryNames.get(0));
        }
        if (messageType.contains("MORE")) {
            return messageBundle.getMessage("MEANINGFUL_DIFFERENCES" + messageType, responseName, explanatoryNames.get(0), String.join((CharSequence)", ", outlierCategories));
        }
        if (containsMultiple && messageType.contains("COUNT")) {
            return messageBundle.getMessage("MEANINGFUL_DIFFERENCES" + messageType, String.join((CharSequence)", ", outlierCategories.subList(0, Math.min(5, outlierCategories.size()) - 1)), outlierCategories.get(Math.min(5, outlierCategories.size()) - 1), explanatoryNames.get(0));
        }
        if (containsMultiple) {
            return messageBundle.getMessage("MEANINGFUL_DIFFERENCES" + messageType, responseName, explanatoryNames.get(0), String.join((CharSequence)", ", outlierCategories.subList(0, Math.min(5, outlierCategories.size()) - 1)), outlierCategories.get(Math.min(5, outlierCategories.size()) - 1));
        }
        if (messageType.contains("COUNT")) {
            return messageBundle.getMessage("MEANINGFUL_DIFFERENCES" + messageType, outlierCategories.get(0), explanatoryNames.get(0));
        }
        return messageBundle.getMessage("MEANINGFUL_DIFFERENCES" + messageType, responseName, explanatoryNames.get(0), outlierCategories.get(0));
    }

    private static <T> long getOutlierCount(List<T> outliers, Predicate<T> where) {
        return outliers.stream().filter(where).count();
    }
}

