/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data;

import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.exceptions.PredictException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueFactory;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Context {
    private static final Config APPCONF = ConfigFactory.parseResourcesAnySyntax((String)"application");
    private Config config = APPCONF;

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBooleanOpt(key).orElse(defaultValue);
    }

    public Optional<Boolean> getBooleanOpt(String key) {
        if (this.has(key)) {
            return Optional.of(this.config.getBoolean(key));
        }
        return Optional.empty();
    }

    public int getInt(String key, int defaultValue) {
        return this.getIntOpt(key).orElse(defaultValue);
    }

    public Optional<Integer> getIntOpt(String key) {
        if (this.has(key)) {
            return Optional.of(this.config.getInt(key));
        }
        return Optional.empty();
    }

    public double getDouble(String key, double defaultValue) {
        return this.getDoubleOpt(key).orElse(defaultValue);
    }

    public Optional<Double> getDoubleOpt(String key) {
        if (this.has(key)) {
            return Optional.of(this.config.getDouble(key));
        }
        return Optional.empty();
    }

    public String getString(String key, String defaultValue) {
        return this.getStringOpt(key).orElse(defaultValue);
    }

    public Optional<String> getStringOpt(String key) {
        if (this.has(key)) {
            return Optional.of(this.config.getString(key));
        }
        return Optional.empty();
    }

    public Locale getLocale(String key) {
        Locale locale = Locale.getDefault();
        if (this.has(key)) {
            String localeStr = this.config.getString(key);
            String[] localeParts = localeStr.split("[-_]");
            locale = localeParts.length > 1 ? new Locale(localeParts[0], localeParts[1].toUpperCase()) : new Locale(localeStr);
        }
        return locale;
    }

    public List<Boolean> getBooleanList(String key, List<Boolean> defaultValue) {
        return this.getBooleanListOpt(key).orElse(defaultValue);
    }

    public Optional<List<Boolean>> getBooleanListOpt(String key) {
        if (this.has(key)) {
            return Optional.of(this.config.getBooleanList(key));
        }
        return Optional.empty();
    }

    public List<Integer> getIntList(String key, List<Integer> defaultValue) {
        return this.getIntListOpt(key).orElse(defaultValue);
    }

    public Optional<List<Integer>> getIntListOpt(String key) {
        if (this.has(key)) {
            return Optional.of(this.config.getIntList(key));
        }
        return Optional.empty();
    }

    public List<Double> getDoubleList(String key, List<Double> defaultValue) {
        return this.getDoubleListOpt(key).orElse(defaultValue);
    }

    public Optional<List<Double>> getDoubleListOpt(String key) {
        if (this.has(key)) {
            return Optional.of(this.config.getDoubleList(key));
        }
        return Optional.empty();
    }

    public List<String> getStringList(String key, List<String> defaultValue) {
        return this.getStringListOpt(key).orElse(defaultValue);
    }

    public Optional<List<String>> getStringListOpt(String key) {
        if (this.has(key)) {
            return Optional.of(this.config.getStringList(key));
        }
        return Optional.empty();
    }

    public Context setValue(String key, Object value) {
        this.config = this.config.withValue(key, ConfigValueFactory.fromAnyRef((Object)value));
        return this;
    }

    public JSONObject getJsonObject(String key, JSONObject defaultValue) {
        return this.getJsonObjectOpt(key).orElse(defaultValue);
    }

    public Optional<JSONObject> getJsonObjectOpt(String key) {
        if (this.has(key)) {
            try {
                String jsonString = this.config.getObject(key).render(ConfigRenderOptions.concise());
                return Optional.of(new JSONObject(jsonString));
            }
            catch (JSONException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public JSONArray getJsonArray(String key, JSONArray defaultValue) {
        return this.getJsonArrayOpt(key).orElse(defaultValue);
    }

    public Optional<JSONArray> getJsonArrayOpt(String key) {
        if (this.has(key)) {
            try {
                String jsonString = this.config.getList(key).render(ConfigRenderOptions.concise());
                return Optional.of(new JSONArray(jsonString));
            }
            catch (JSONException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    protected void setIfPresent(String key, Map<String, Object> params) {
        String strippedKey = this.strippedKey(key);
        if (params.containsKey(strippedKey)) {
            this.setValue(key, params.get(strippedKey));
        }
    }

    protected void set(String key, JSONObject params) {
        String strippedKey = this.strippedKey(key);
        if (!params.has(strippedKey)) {
            throw new BadParametersException("Missing required parameters: " + strippedKey);
        }
        try {
            this.setValue(key, params.get(strippedKey));
        }
        catch (JSONException e) {
            throw new PredictException("Error while parsing parameters. Reason: " + e.getMessage(), e);
        }
    }

    protected void set(String key, JSONObject params, Function<Object, Object> processor) {
        String strippedKey = this.strippedKey(key);
        Object result = processor.apply(params.opt(strippedKey));
        if (result != null) {
            this.setValue(key, result);
        }
    }

    protected String configPrefix() {
        return "";
    }

    private boolean has(String key) {
        return this.config.hasPath(key) && !this.config.getIsNull(key);
    }

    private String strippedKey(String key) {
        String prefix = this.configPrefix();
        if (key.startsWith(prefix)) {
            return key.substring(prefix.length(), key.length());
        }
        return key;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }
}

