/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.math;

import com.ibm.bi.predict.math.NumericUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;

public class NumberFormatter {
    private static final double ALWAYS_SHOW_AS_ZERO = 1.0E-18;
    private static final int DESIRED_SIGNIFICANT_DIGITS = 4;
    private static final int DESIRED_PERCENT_DECIMAL_DIGITS = 1;
    private static final int DESIRED_DECIMAL_DIGITS_FOR_COUNT = 1;
    private static final double TOO_BIG_FOR_DECIMAL = 15.0;
    private static final double TOO_SMALL_FOR_DECIMAL = -5.0;
    private static final double MIN_FOR_COMMA_FORMAT = 10000.0;
    private static final double TOO_SMALL_FOR_COUNT = 0.1;
    private static final double TOO_LARGE_FOR_COUNT = 1.0E15;
    private static final double ROUNDING_THRESHOLD_FOR_COUNT = 1000.0;
    private static final Map<FormatKey, NumberFormat> formats = new HashMap<FormatKey, NumberFormat>();
    private static final DecimalFormat SCIENTIFIC = new DecimalFormat("0.###E0");

    private NumberFormatter() {
    }

    public static synchronized String format(Locale locale, boolean useGrouping, double v) {
        if (!Double.isFinite(v)) {
            return Double.toString(v);
        }
        double sign = Math.signum(v);
        double a = Math.abs(v);
        if (a < 1.0E-18) {
            FormatKey key = new FormatKey(locale, 0, false);
            return formats.computeIfAbsent(key, NumberFormatter::makeDecimalFormat).format(0L);
        }
        double pow10 = Math.log10(a);
        if (pow10 < -5.0 || pow10 > 15.0) {
            return SCIENTIFIC.format(sign * a);
        }
        int places = Math.max(0, 4 - (int)Math.ceil(pow10));
        FormatKey key = new FormatKey(locale, places, useGrouping && a >= 10000.0);
        return formats.computeIfAbsent(key, NumberFormatter::makeDecimalFormat).format(v);
    }

    public static synchronized String formatCount(Locale locale, boolean useGrouping, double v) {
        if (v < 0.1 || v > 1.0E15) {
            return NumberFormatter.format(locale, useGrouping, v);
        }
        if (v > 1000.0) {
            return NumberFormatter.format(locale, useGrouping, Math.round(v));
        }
        FormatKey key = new FormatKey(locale, 1, useGrouping);
        return formats.computeIfAbsent(key, NumberFormatter::makeDecimalFormat).format(v);
    }

    public static synchronized String formatAsPercent(Locale locale, double v) {
        int places = 1;
        boolean isGroupingUsed = false;
        FormatKey key = new FormatKey(locale, places, isGroupingUsed);
        return formats.computeIfAbsent(key, NumberFormatter::makeDecimalFormat).format(v);
    }

    public static String percentFormat(Locale locale, double v) {
        int places = 1;
        boolean isGroupingUsed = false;
        FormatKey key = new FormatKey(locale, places, isGroupingUsed);
        NumberFormat formatter = NumberFormatter.makePercentFormat(key);
        String formatted = formatter.format(v);
        try {
            double parsed = formatter.parse(formatted).doubleValue();
            if (NumericUtils.isZero(parsed)) {
                return formatter.format(0L);
            }
            return formatted;
        }
        catch (ParseException e) {
            return formatted;
        }
    }

    public static int decimalPlacesForRange(double a, double b) {
        TreeSet<Double> consider = new TreeSet<Double>();
        if (!NumericUtils.equals(a, 0.0)) {
            consider.add(Math.abs(a));
        }
        if (!NumericUtils.equals(b, 0.0)) {
            consider.add(Math.abs(b));
        }
        if (!NumericUtils.equals(b - a, 0.0)) {
            consider.add(Math.abs(b - a));
        }
        if (consider.isEmpty()) {
            return 0;
        }
        return -((int)Math.floor(Math.log10((Double)consider.first())));
    }

    private static NumberFormat makeDecimalFormat(FormatKey key) {
        NumberFormat format = NumberFormat.getNumberInstance(key.locale);
        format.setGroupingUsed(key.useGrouping);
        format.setMaximumFractionDigits(key.places);
        return format;
    }

    private static NumberFormat makePercentFormat(FormatKey key) {
        NumberFormat format = NumberFormat.getPercentInstance(key.locale);
        format.setGroupingUsed(key.useGrouping);
        format.setMaximumFractionDigits(key.places);
        return format;
    }

    private static final class FormatKey {
        private final Locale locale;
        private final int places;
        private final boolean useGrouping;

        private FormatKey(Locale locale, int places, boolean useGrouping) {
            this.locale = locale;
            this.places = places;
            this.useGrouping = useGrouping;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FormatKey formatKey = (FormatKey)o;
            if (this.places != formatKey.places) {
                return false;
            }
            if (this.useGrouping != formatKey.useGrouping) {
                return false;
            }
            return this.locale.equals(formatKey.locale);
        }

        public int hashCode() {
            int result = this.locale.hashCode();
            result = 31 * result + this.places;
            result = 31 * result + (this.useGrouping ? 1 : 0);
            return result;
        }
    }
}

