/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.math;

import com.ibm.bi.predict.sa.execution.utils.TriFunction;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.ToDoubleBiFunction;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.math3.util.Precision;

public class NumericUtils {
    public static final double MISSING_VALUE = Double.NaN;
    public static final double EPSILON = 1.0E-9;
    public static final RoundingMode roundingMode = RoundingMode.HALF_UP;

    private NumericUtils() {
    }

    public static boolean equals(float f1, float f2) {
        return NumericUtils.equals(f1, f2, 1.0E-9);
    }

    public static boolean equals(double d1, double d2) {
        return NumericUtils.equals(d1, d2, 1.0E-9);
    }

    public static boolean isMissingValue(double d) {
        return Double.isNaN(d);
    }

    public static boolean equals(double d1, double d2, double epsilon) {
        if (d1 == 0.0 || d2 == 0.0) {
            return d1 - d2 == 0.0;
        }
        return Precision.equals((double)d1, (double)d2, (double)epsilon);
    }

    public static boolean equals(float f1, float f2, double epsilon) {
        if (f1 == 0.0f || f2 == 0.0f) {
            return f1 - f2 == 0.0f;
        }
        return Precision.equals((double)f1, (double)f2, (double)epsilon);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        MathContext mathContext = new MathContext(places, roundingMode);
        BigDecimal bigDecimal = BigDecimal.valueOf(value).round(mathContext);
        return bigDecimal.doubleValue();
    }

    public static boolean isZero(double value) {
        return NumericUtils.equals(0.0, value);
    }

    public static double[] listToDoubleArray(List<Double> l) {
        return l.stream().mapToDouble(Double::doubleValue).toArray();
    }

    public static double sumList(Collection<Double> l) {
        return l.stream().reduce(0.0, (acc, v) -> acc + v);
    }

    public static double sumList(Collection<Double> l, DoubleFunction<Double> fn) {
        return l.stream().reduce(0.0, (acc, v) -> acc + (Double)fn.apply((double)v));
    }

    public static DoubleStream zipDoubles(List<Double> l1, List<Double> l2, ToDoubleBiFunction<Double, Double> fn) {
        return IntStream.range(0, l1.size()).mapToDouble(i -> fn.applyAsDouble((Double)l1.get(i), (Double)l2.get(i)));
    }

    public static <T, U, R> Stream<R> zip(List<T> l1, List<U> l2, BiFunction<T, U, R> fn) {
        return IntStream.range(0, l1.size()).mapToObj(i -> fn.apply(l1.get(i), l2.get(i)));
    }

    public static <T, U, R> Stream<R> zipWithIndex(List<T> l1, List<U> l2, TriFunction<T, U, Integer, R> fn) {
        return IntStream.range(0, l1.size()).mapToObj(i -> fn.apply(l1.get(i), l2.get(i), i));
    }

    public static int countWhere(double[][] vals, Function<Integer, Function<Integer, Function<Double, Boolean>>> where) {
        int count = 0;
        for (int i = 0; i < vals.length; ++i) {
            for (int j = 0; j < vals[i].length; ++j) {
                if (!where.apply(i).apply(j).apply(vals[i][j]).booleanValue()) continue;
                ++count;
            }
        }
        return count;
    }

    public static double mean(double[] y, int n) {
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += y[i];
        }
        return sum / (double)n;
    }

    public static double mean(double[] y) {
        double sum = 0.0;
        for (double v : y) {
            sum += v;
        }
        return sum / (double)y.length;
    }

    public static double[] movingAverageSmooth(double[] y, int n, int k) {
        if (k >= n) {
            throw new IllegalArgumentException("Cannot smooth with period longer than the data");
        }
        double sum = 0.0;
        for (int i = 0; i <= k; ++i) {
            sum += y[i];
        }
        int count = k + 1;
        double[] smooth = new double[n];
        smooth[0] = sum / (double)count;
        for (int i = 1; i < n; ++i) {
            if (i - k >= 0) {
                sum -= y[i - k];
                --count;
            }
            if (i + k < y.length) {
                sum += y[i + k];
                ++count;
            }
            smooth[i] = sum / (double)count;
        }
        return smooth;
    }

    private static boolean isEven(int i) {
        return (i & 1) != 1;
    }

    public static double[] movingAverageSmoothAdjusted(double[] data, int m, int lower, int window) {
        int n = data.length;
        if (m + window > n) {
            throw new IllegalArgumentException("Cannot smooth with period longer than the data");
        }
        double[] smooth = new double[m + window];
        if (!NumericUtils.isEven(m)) {
            int i;
            double sum = 0.0;
            for (i = 0; i < m; ++i) {
                sum += data[i];
            }
            smooth[lower] = sum / (double)m;
            for (i = 1; i < window; ++i) {
                sum -= data[i - 1];
                smooth[lower + i] = (sum += data[i + m - 1]) / (double)m;
            }
        } else {
            int i;
            double sum = 0.5 * data[0];
            for (i = 1; i < m; ++i) {
                sum += data[i];
            }
            smooth[lower] = (sum += 0.5 * data[m]) / (double)m;
            for (i = 1; i < window; ++i) {
                sum -= 0.5 * data[i - 1];
                sum -= 0.5 * data[i];
                sum += 0.5 * data[i + m - 1];
                smooth[lower + i] = (sum += 0.5 * data[i + m]) / (double)m;
            }
        }
        return smooth;
    }

    public static boolean isUnique(int candidateIndex, double[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (!NumericUtils.equals(values[candidateIndex], values[i]) || i == candidateIndex) continue;
            return false;
        }
        return true;
    }

    public static double[] simpleLinearRegression(double[] y, int n) {
        double ybar = NumericUtils.mean(y, n);
        double xbar = (double)(n - 1) / 2.0;
        double xxbar = 0.0;
        double xybar = 0.0;
        for (int i = 0; i < n; ++i) {
            xxbar += ((double)i - xbar) * ((double)i - xbar);
            xybar += ((double)i - xbar) * (y[i] - ybar);
        }
        double slope = xybar / xxbar;
        double intercept = ybar - slope * xbar;
        return new double[]{intercept, slope};
    }

    public static double sumOfSquares(double[] data, double mean) {
        double sum = 0.0;
        for (double v : data) {
            sum += (v - mean) * (v - mean);
        }
        return sum;
    }

    public static boolean tryParseDouble(String value) {
        if (value == null) {
            return false;
        }
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean tryParseInt(String value) {
        if (value == null) {
            return false;
        }
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int argmax(double[] y) {
        if (y.length <= 0) {
            return -1;
        }
        int ind = 0;
        double curMax = y[0];
        for (int i = 1; i < y.length; ++i) {
            if (!(y[i] > curMax)) continue;
            curMax = y[i];
            ind = i;
        }
        return ind;
    }

    public static int argmin(double[] y) {
        if (y.length <= 0) {
            return -1;
        }
        int ind = 0;
        double curMin = y[0];
        for (int i = 1; i < y.length; ++i) {
            if (!(y[i] < curMin)) continue;
            curMin = y[i];
            ind = i;
        }
        return ind;
    }
}

