/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.math;

import com.ibm.bi.predict.math.NumericUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.math3.stat.StatUtils;

public class PickNAlgorithm {
    private PickNAlgorithm() {
    }

    public static int pickTopN(double[] values, int numMax) {
        double cumulativeSum = 0.0;
        double totalSum = StatUtils.sum((double[])values);
        BigDecimal[] excessRatios = new BigDecimal[values.length + 1];
        excessRatios[values.length] = BigDecimal.ONE;
        for (int i = 0; i < values.length; ++i) {
            int N = i + 1;
            double cumulativeFraction = (cumulativeSum += values[i]) / totalSum;
            double expectedFraction = (double)N / (double)values.length;
            double excessRatio = cumulativeFraction / expectedFraction;
            BigDecimal bd = BigDecimal.valueOf(excessRatio);
            excessRatios[i] = bd.setScale(9, RoundingMode.HALF_UP);
        }
        double maxDiff = Double.NEGATIVE_INFINITY;
        int maxN = 0;
        for (int i = 0; i < values.length; ++i) {
            double diff = excessRatios[i].subtract(excessRatios[i + 1]).doubleValue();
            int N = i + 1;
            if (!(diff > maxDiff) && !NumericUtils.equals(diff, maxDiff)) continue;
            maxN = N;
            maxDiff = diff;
        }
        return Math.min(maxN, numMax);
    }
}

