/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.math;

import com.ibm.bi.predict.math.PickNAlgorithm;

public class TopNSelector {
    private static final int MAX_POINTS = 10;
    private static final double MAX_DIVISOR = 3.0;

    private TopNSelector() {
    }

    public static int selectTopN(double[] values, int numDataPoints) {
        int maxPoints = TopNSelector.determineMaxLimit(numDataPoints);
        if (values.length <= maxPoints) {
            return values.length;
        }
        int numPoints = PickNAlgorithm.pickTopN(values, 10);
        return Math.min(maxPoints, numPoints);
    }

    private static int determineMaxLimit(int numDataPoints) {
        return Math.min((int)Math.round((double)numDataPoints / 3.0), 10);
    }
}

