/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.result;

import java.util.Objects;

public class Version
implements Comparable<Version> {
    public static final Version LATEST = new Version(1, 1, 0);
    private int major;
    private int minor;
    private int revision;

    public Version(int major, int minor, int revision) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
    }

    public static Version parse(String version) {
        if (!version.matches("[0-9]+(\\.[0-9]+)*")) {
            return null;
        }
        String[] parts = version.split("\\.");
        if (parts.length <= 0 || parts.length > 3) {
            return null;
        }
        try {
            return Version.tryParse(parts);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Version tryParse(String[] parts) {
        int major = Integer.parseInt(parts[0]);
        int minor = parts.length >= 2 ? Integer.parseInt(parts[1]) : 0;
        int revision = parts.length >= 3 ? Integer.parseInt(parts[2]) : 0;
        return new Version(major, minor, revision);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int revision() {
        return this.revision;
    }

    public boolean before(Version otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public boolean after(Version otherVersion) {
        return this.compareTo(otherVersion) > 0;
    }

    @Override
    public int compareTo(Version otherVersion) {
        if (this.major < otherVersion.major) {
            return -1;
        }
        if (this.major > otherVersion.major) {
            return 1;
        }
        if (this.minor < otherVersion.minor) {
            return -1;
        }
        if (this.minor > otherVersion.minor) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.compareTo(version) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor);
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.revision);
    }
}

