/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.testharness;

import com.ibm.bi.predict.testharness.Harness;
import com.ibm.bi.predict.testharness.TaskParameters;
import com.ibm.bi.predict.testharness.TaskResult;
import com.ibm.bi.predict.testharness.TaskStats;
import com.ibm.bi.predict.utils.EnvironmentInfo;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class OutputWriter {
    private static final Logger logger = PredictLoggerFactory.getLogger(OutputWriter.class);
    private static final String SUMMARY_NAME = "summary.txt";
    private static final String STATISTICS_NAME = "statistics";
    private static final String FAILURES_NAME = "failures.txt";
    private static final String TRACE_NAME = "trace";
    private final String name;
    private final Path outputPath;

    OutputWriter(String basicName, Path outputPath) {
        this.name = this.makeName(basicName);
        this.outputPath = outputPath;
    }

    void write(List<List<TaskResult>> userResults, int timeToCompletion, Harness.StatsDetail detail, EnvironmentInfo env) {
        if (!this.outputDirectoryExists()) {
            this.makeOutputDirectory();
        }
        logger.info("Writing information to: " + this.outputPath.resolve(this.name));
        this.writeSummary(userResults, timeToCompletion, env);
        this.writeStatistics(userResults, detail, env);
        this.writeFailures(userResults);
        this.writeTrace(userResults);
    }

    private void writeSummary(List<List<TaskResult>> userResults, double timeToCompletion, EnvironmentInfo env) {
        this.writeToFile(this.makeFilePath(this.outputPath, SUMMARY_NAME), writer -> {
            writer.format("Run:          %s%n", this.name).format("Time (s):     %f%n", timeToCompletion / 1000.0).format("Users:        %d%n", userResults.size()).format("Total Tasks:  %d%n", this.individualTasks(userResults).count()).format("Machine:      %s%n", env.getMachineName()).format("CPUs:         %d%n", env.getAvailableProcessors()).format("Max Memory:   %.0f MB%n", env.getJvmMaxMemoryInMB()).format("Start Memory: %.3f MB%n", env.getStartingUsedMemoryInMB()).format("Final Memory: %.3f MB%n", env.getEndingUsedMemoryInMB()).format("Machine OS:   %s%n", env.getOs()).format("Java Vendor:  %s%n", env.getJavaType()).format("Java Version  %s%n", env.getJavaVersion()).format("Java Home:    %s%n", env.getJavaHome());
            Map<TaskResult.State, List<TaskResult>> summary = this.groupResultsByState(userResults);
            for (TaskResult.State state : TaskResult.State.values()) {
                List r = summary.getOrDefault((Object)state, Collections.emptyList());
                writer.format(" # %-9s: %d%n", state.toString(), r.size());
            }
        });
    }

    private void writeStatistics(List<List<TaskResult>> userResults, Harness.StatsDetail detail, EnvironmentInfo env) {
        String statsFileName = String.format("%s.csv", STATISTICS_NAME);
        this.writeToFile(this.makeFilePath(this.outputPath, statsFileName), writer -> {
            writer.print("count,fails,timeMed,total,");
            if (detail != Harness.StatsDetail.minimal) {
                writer.print("time90%,");
                writer.print("timeAvg,timeSD,min,max,");
            }
            if (detail == Harness.StatsDetail.all) {
                writer.print("CPUs,maxMem,lostMem,");
            }
            writer.println("parameters");
            Map<TaskParameters, List<TaskResult>> byParameters = this.individualTasks(userResults).collect(Collectors.groupingBy(TaskResult::parameters));
            byParameters.keySet().stream().sorted().forEach(parameters -> this.writeStatisticsLine((PrintWriter)writer, (TaskParameters)parameters, (List)byParameters.get(parameters), detail, env));
        });
    }

    private void writeFailures(List<List<TaskResult>> userResults) {
        this.writeToFile(this.makeFilePath(this.outputPath, FAILURES_NAME), writer -> this.individualTasks(userResults).filter(this::isFailure).forEach(task -> {
            writer.println(task.state().toString().toUpperCase() + " for " + task.parameters());
            writer.format("Ran from %.3f to %.3f%n", task.timeStart(), task.timeEnd());
            for (Throwable error = task.error(); error != null; error = error.getCause()) {
                error.printStackTrace((PrintWriter)writer);
            }
        }));
    }

    private void writeTrace(List<List<TaskResult>> userResults) {
        String traceFileName = String.format("%s.csv", TRACE_NAME);
        this.writeToFile(this.makeFilePath(this.outputPath, traceFileName), writer -> {
            writer.println("index,start,end,total,status,thread,params,message");
            List list = this.individualTasks(userResults).sorted().collect(Collectors.toList());
            for (int i = 0; i < list.size(); ++i) {
                TaskResult t = (TaskResult)list.get(i);
                writer.format("%5d,%7.3f,%7.3f,%7.3f,%9.9s,%5d,%s,%s%n", new Object[]{i, t.timeStart(), t.timeEnd(), t.totalTime(), t.state(), t.thread(), this.sanitize(t.parameters()), this.sanitize(t.message())});
            }
        });
    }

    private void writeStatisticsLine(PrintWriter writer, TaskParameters parameters, List<TaskResult> list, Harness.StatsDetail detail, EnvironmentInfo env) {
        TaskStats timeStats = new TaskStats(list, TaskResult::timeInSeconds);
        TaskStats failStats = new TaskStats(list, t -> t.state() == TaskResult.State.success ? 0.0 : 1.0);
        writer.format("%7d,%7d,%7.3f,%7.3f,", timeStats.count, failStats.countGtrZero, timeStats.median, timeStats.total);
        if (detail != Harness.StatsDetail.minimal) {
            writer.format("%7.3f,", timeStats.upper90Percent).format("%7.3f,%7.3f,%7.3f,%7.3f,", timeStats.average, timeStats.stddev, timeStats.min, timeStats.max);
        }
        if (detail == Harness.StatsDetail.all) {
            writer.format("%7d,%7.0f,%7.3f,", env.getAvailableProcessors(), env.getJvmMaxMemoryInMB(), env.getLostMemory());
        }
        writer.print(" ");
        writer.println(parameters.asCSV());
    }

    private String sanitize(Object object) {
        if (object == null) {
            return "(null)";
        }
        String s = object.toString();
        return s.replaceAll(",", " ").replaceAll("\"", "'");
    }

    private boolean isFailure(TaskResult result) {
        return result.state() != TaskResult.State.success;
    }

    private void writeToFile(Path path, Consumer<PrintWriter> p) {
        try (PrintWriter writer = this.makeWriteableFile(path);){
            p.accept(writer);
        }
    }

    private Map<TaskResult.State, List<TaskResult>> groupResultsByState(List<List<TaskResult>> results) {
        return this.individualTasks(results).collect(Collectors.groupingBy(TaskResult::state));
    }

    private Stream<TaskResult> individualTasks(List<List<TaskResult>> items) {
        return items.stream().flatMap(Collection::stream);
    }

    private PrintWriter makeWriteableFile(Path p) {
        try {
            return new PrintWriter(p.toFile());
        }
        catch (FileNotFoundException e) {
            logger.error("Issue while creating output file: " + p.getFileName() + ". Reason: " + e.getMessage(), e);
            throw new RuntimeException("Issue while creating output file: " + p.getFileName(), e);
        }
    }

    private Path makeFilePath(Path outputPath, String fileName) {
        return outputPath.resolve(this.name).resolve(fileName);
    }

    private boolean outputDirectoryExists() {
        return this.outputPath.resolve(this.name).toFile().exists();
    }

    private void makeOutputDirectory() {
        Path pathToCreate = this.outputPath.resolve(this.name);
        try {
            Files.createDirectory(pathToCreate, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Could not create directory for the run: " + pathToCreate.getFileName());
            throw new RuntimeException("Could not create directory for the run: " + pathToCreate.getFileName(), e);
        }
    }

    private String makeName(String name) {
        SimpleDateFormat d = new SimpleDateFormat("yyyyMMdd HH-mm-ss");
        return String.format("%s - %s", name, d.format(new Date()));
    }
}

