/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.testharness;

import com.ibm.bi.predict.testharness.TaskResult;
import java.util.Arrays;
import java.util.List;
import java.util.function.ToDoubleFunction;

class TaskStats {
    final int count;
    final double average;
    final double median;
    final double upper90Percent;
    final int countGtrZero;
    final double stddev;
    final double min;
    final double max;
    final double total;

    TaskStats(List<TaskResult> list, ToDoubleFunction<TaskResult> target) {
        double[] data = list.stream().mapToDouble(target).toArray();
        Arrays.sort(data);
        this.count = data.length;
        this.total = Arrays.stream(data).sum();
        this.average = this.total / (double)this.count;
        this.median = (data[this.count / 2] + data[(this.count - 1) / 2]) / 2.0;
        this.upper90Percent = data[this.count * 9 / 10];
        int c = 0;
        double ss = 0.0;
        for (double val : data) {
            ss += (val - this.average) * (val - this.average);
            if (!(val > 0.0)) continue;
            ++c;
        }
        this.countGtrZero = c;
        this.stddev = this.count == 1 ? 0.0 : Math.sqrt(ss / (double)(this.count - 1));
        this.min = Arrays.stream(data).min().getAsDouble();
        this.max = Arrays.stream(data).max().getAsDouble();
    }
}

