/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.testharness;

import com.ibm.bi.predict.testharness.TaskParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class User {
    private final List<Task> tasks = new ArrayList<Task>();

    public static User withSingleTask(Function<TaskParameters, String> action) {
        return new User().addTask(TaskParameters.empty(), action);
    }

    public static User withSingleTask(Function<TaskParameters, String> action, TaskParameters parameters) {
        return new User().addTask(parameters, action);
    }

    public static User withSameAction(Function<TaskParameters, String> action, TaskParameters ... parameters) {
        User user = new User();
        for (TaskParameters parameter : parameters) {
            user.addTask(parameter, action);
        }
        return user;
    }

    public static User withRepeatedTask(Function<TaskParameters, String> action, int numRepeated, TaskParameters parameter) {
        User user = new User();
        for (int i = 0; i < numRepeated; ++i) {
            user.addTask(parameter, action);
        }
        return user;
    }

    public static User withRepeatedTask(Function<TaskParameters, String> action, int numRepeated) {
        User user = new User();
        for (int i = 0; i < numRepeated; ++i) {
            user.addTask(TaskParameters.empty(), action);
        }
        return user;
    }

    private User addTask(TaskParameters parameters, Function<TaskParameters, String> action) {
        this.tasks.add(new Task(parameters, action));
        return this;
    }

    public List<Task> tasks() {
        return this.tasks;
    }

    static class Task {
        final TaskParameters parameters;
        final Function<TaskParameters, String> action;

        public Task(TaskParameters parameters, Function<TaskParameters, String> action) {
            this.parameters = parameters;
            this.action = action;
        }
    }
}

